/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.block.BlockWallBase;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.event.block.DoorToggleEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Location;
import cn.nukkit.level.Sound;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.RedstoneComponent;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@PowerNukkitDifference(info="Implements RedstoneComponent.", since="1.4.0.0-PN")
public class BlockFenceGate
extends BlockTransparentMeta
implements RedstoneComponent,
Faceable {
    private static final List<Location> manualOverrides = new ArrayList<Location>();
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public static final BooleanBlockProperty IN_WALL = new BooleanBlockProperty("in_wall_bit", false);
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.DIRECTION, CommonBlockProperties.OPEN, IN_WALL);
    private static final double[] offMinX = new double[2];
    private static final double[] offMinZ = new double[2];
    private static final double[] offMaxX = new double[2];
    private static final double[] offMaxZ = new double[2];

    public BlockFenceGate() {
        this(0);
    }

    public BlockFenceGate(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 107;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getName() {
        return "Oak Fence Gate";
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 15.0;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    private int getOffsetIndex() {
        switch (this.getBlockFace()) {
            case SOUTH: 
            case NORTH: {
                return 0;
            }
        }
        return 1;
    }

    @Override
    public double getMinX() {
        return this.x + offMinX[this.getOffsetIndex()];
    }

    @Override
    public double getMinZ() {
        return this.z + offMinZ[this.getOffsetIndex()];
    }

    @Override
    public double getMaxX() {
        return this.x + offMaxX[this.getOffsetIndex()];
    }

    @Override
    public double getMaxZ() {
        return this.z + offMaxZ[this.getOffsetIndex()];
    }

    @Override
    @PowerNukkitDifference.DifferenceList(value={@PowerNukkitDifference(info="InWall property is now properly set, returns false if setBlock fails", since="1.4.0.0-PN"), @PowerNukkitDifference(info="Open door if redstone signal is detected.", since="1.4.0.0-PN")})
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        BlockFace direction = player.getDirection();
        this.setBlockFace(direction);
        if (this.getSide(direction.rotateY()) instanceof BlockWallBase || this.getSide(direction.rotateYCCW()) instanceof BlockWallBase) {
            this.setInWall(true);
        }
        if (!this.getLevel().setBlock((Vector3)block, this, true, true)) {
            return false;
        }
        if (this.level.getServer().isRedstoneEnabled() && !this.isOpen() && this.isGettingPower()) {
            this.setOpen(null, true);
        }
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        return this.toggle(player);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    @PowerNukkitDifference(info="Just call the #setOpen() method.", since="1.4.0.0-PN")
    public boolean toggle(Player player) {
        return this.setOpen(player, !this.isOpen());
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean setOpen(Player player, boolean open) {
        BlockFace direction;
        if (open == this.isOpen()) {
            return false;
        }
        DoorToggleEvent event = new DoorToggleEvent(this, player);
        this.getLevel().getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        player = event.getPlayer();
        BlockFace originDirection = this.getBlockFace();
        if (player != null) {
            double yaw = player.yaw;
            double rotation = (yaw - 90.0) % 360.0;
            if (rotation < 0.0) {
                rotation += 360.0;
            }
            direction = originDirection.getAxis() == BlockFace.Axis.Z ? (rotation >= 0.0 && rotation < 180.0 ? BlockFace.NORTH : BlockFace.SOUTH) : (rotation >= 90.0 && rotation < 270.0 ? BlockFace.EAST : BlockFace.WEST);
        } else {
            direction = originDirection.getAxis() == BlockFace.Axis.Z ? BlockFace.SOUTH : BlockFace.WEST;
        }
        this.setBlockFace(direction);
        this.toggleBooleanProperty(CommonBlockProperties.OPEN);
        this.level.setBlock((Vector3)this, this, false, false);
        if (player != null) {
            this.setManualOverride(this.isGettingPower() || this.isOpen());
        }
        this.playOpenCloseSound();
        return true;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void playOpenCloseSound() {
        if (this.isOpen()) {
            this.playOpenSound();
        } else {
            this.playCloseSound();
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void playOpenSound() {
        this.level.addSound(this, Sound.RANDOM_DOOR_OPEN);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void playCloseSound() {
        this.level.addSound(this, Sound.RANDOM_DOOR_CLOSE);
    }

    public boolean isOpen() {
        return this.getBooleanValue(CommonBlockProperties.OPEN);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setOpen(boolean open) {
        this.setBooleanValue(CommonBlockProperties.OPEN, open);
    }

    @Override
    @PowerNukkitDifference(info="Will connect to walls correctly", since="1.4.0.0-PN")
    public int onUpdate(int type) {
        if (type == 1) {
            boolean touchingWall;
            BlockFace face = this.getBlockFace();
            boolean bl = touchingWall = this.getSide(face.rotateY()) instanceof BlockWallBase || this.getSide(face.rotateYCCW()) instanceof BlockWallBase;
            if (touchingWall != this.isInWall()) {
                this.setInWall(touchingWall);
                this.level.setBlock((Vector3)this, this, true);
                return type;
            }
        } else if (type == 6 && this.level.getServer().isRedstoneEnabled()) {
            this.onRedstoneUpdate();
            return type;
        }
        return 0;
    }

    @PowerNukkitDifference(info="Checking if the door was opened/closed manually.", since="1.4.0.0-PN")
    private void onRedstoneUpdate() {
        if (this.isOpen() != this.isGettingPower() && !this.getManualOverride()) {
            if (this.isOpen() != this.isGettingPower()) {
                this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, this.isOpen() ? 15 : 0, this.isOpen() ? 0 : 15));
                this.setOpen(null, this.isGettingPower());
            }
        } else if (this.getManualOverride() && this.isGettingPower() == this.isOpen()) {
            this.setManualOverride(false);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setManualOverride(boolean val) {
        if (val) {
            manualOverrides.add(this.getLocation());
        } else {
            manualOverrides.remove(this.getLocation());
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean getManualOverride() {
        return manualOverrides.contains(this.getLocation());
    }

    @Override
    public boolean onBreak(Item item) {
        this.setManualOverride(false);
        return super.onBreak(item);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isInWall() {
        return this.getBooleanValue(IN_WALL);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setInWall(boolean inWall) {
        this.setBooleanValue(IN_WALL, inWall);
    }

    @Override
    public BlockFace getBlockFace() {
        return this.getPropertyValue(CommonBlockProperties.DIRECTION);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setBlockFace(BlockFace face) {
        this.setPropertyValue(CommonBlockProperties.DIRECTION, face);
    }

    static {
        BlockFenceGate.offMinX[0] = 0.0;
        BlockFenceGate.offMinZ[0] = 0.375;
        BlockFenceGate.offMaxX[0] = 1.0;
        BlockFenceGate.offMaxZ[0] = 0.625;
        BlockFenceGate.offMinX[1] = 0.375;
        BlockFenceGate.offMinZ[1] = 0.0;
        BlockFenceGate.offMaxX[1] = 0.625;
        BlockFenceGate.offMaxZ[1] = 1.0;
    }
}

