/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.item.Item;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Since(value="1.4.0.0-PN")
@PowerNukkitOnly
public abstract class BlockFungus
extends BlockFlowable {
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    protected BlockFungus() {
        super(0);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return CommonBlockProperties.EMPTY_PROPERTIES;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (!this.isValidSupport(this.down())) {
            return false;
        }
        return super.place(item, block, target, face, fx, fy, fz, player);
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && !this.isValidSupport(this.down())) {
            this.level.useBreakOn(this);
            return type;
        }
        return 0;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        Block down;
        if (item.isNull() || !item.isFertilizer()) {
            return false;
        }
        this.level.addParticle(new BoneMealParticle(this));
        if (player != null && !player.isCreative()) {
            --item.count;
        }
        if (!this.isValidSupport(down = this.down())) {
            this.level.useBreakOn(this);
            return true;
        }
        if (!this.canGrowOn(down) || (double)ThreadLocalRandom.current().nextFloat() >= 0.4) {
            return true;
        }
        this.grow(player);
        return true;
    }

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    protected abstract boolean canGrowOn(Block var1);

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    protected boolean isValidSupport(@Nonnull Block support) {
        switch (support.getId()) {
            case 2: 
            case 3: 
            case 60: 
            case 110: 
            case 243: 
            case 487: 
            case 488: 
            case 491: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public abstract boolean grow(@Nullable Player var1);
}

