/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import javax.annotation.Nonnull;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public abstract class BlockLog
extends BlockSolidMeta {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected static final BlockProperties PILLAR_PROPERTIES = new BlockProperties(CommonBlockProperties.PILLAR_AXIS);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected BlockLog(int meta) {
        super(meta);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public abstract BlockProperties getProperties();

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected abstract BlockState getStrippedState();

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockFace.Axis getPillarAxis() {
        return this.getPropertyValue(CommonBlockProperties.PILLAR_AXIS);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setPillarAxis(BlockFace.Axis axis) {
        this.setPropertyValue(CommonBlockProperties.PILLAR_AXIS, axis);
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        this.setPillarAxis(face.getAxis());
        this.getLevel().setBlock((Vector3)block, this, true, true);
        return true;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (item.isAxe()) {
            Block strippedBlock = this.getStrippedState().getBlock(this);
            item.useOn(this);
            this.level.setBlock((Vector3)this, strippedBlock, true, true);
            return true;
        }
        return false;
    }

    @Override
    public int getToolType() {
        return 4;
    }
}

