/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BlockNetherrack
extends BlockSolid {
    @Override
    public int getId() {
        return 87;
    }

    @Override
    public double getResistance() {
        return 2.0;
    }

    @Override
    public double getHardness() {
        return 0.4;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public String getName() {
        return "Netherrack";
    }

    @Override
    public int getToolTier() {
        return 1;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, @Nullable Player player) {
        if (item.isNull() || !item.isFertilizer() || this.up().getId() != 0) {
            return false;
        }
        IntArrayList options = new IntArrayList(2);
        for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
            int id = this.getSide(face).getId();
            if (id != 487 && id != 488 || options.contains(id)) continue;
            options.add(id);
        }
        int size = options.size();
        if (size == 0) {
            return false;
        }
        int nylium = size == 1 ? options.getInt(0) : options.getInt(ThreadLocalRandom.current().nextInt(size));
        if (this.level.setBlock((Vector3)this, Block.get(nylium), true)) {
            if (player == null || !player.isCreative()) {
                --item.count;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.NETHERRACK_BLOCK_COLOR;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

