/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BlockSlab
extends BlockTransparentMeta {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BooleanBlockProperty TOP_SLOT_PROPERTY = new BooleanBlockProperty("top_slot_bit", false);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties SIMPLE_SLAB_PROPERTIES = new BlockProperties(TOP_SLOT_PROPERTY);
    protected final int doubleSlab;

    public BlockSlab(int meta, int doubleSlab) {
        super(meta);
        this.doubleSlab = doubleSlab;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public abstract String getSlabName();

    @Override
    public String getName() {
        return (this.isOnTop() ? "Upper " : "") + this.getSlabName() + " Slab";
    }

    @Override
    public double getMinY() {
        return this.isOnTop() ? this.y + 0.5 : this.y;
    }

    @Override
    public double getMaxY() {
        return this.isOnTop() ? this.y + 1.0 : this.y + 0.5;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return this.getToolType() < 4 ? 30.0 : 15.0;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isOnTop() {
        return this.getBooleanValue(TOP_SLOT_PROPERTY);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setOnTop(boolean top) {
        this.setBooleanValue(TOP_SLOT_PROPERTY, top);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public abstract boolean isSameType(BlockSlab var1);

    @Override
    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public boolean isSolid(BlockFace side) {
        return side == BlockFace.UP && this.isOnTop() || side == BlockFace.DOWN && !this.isOnTop();
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        this.setOnTop(false);
        if (face == BlockFace.DOWN) {
            if (target instanceof BlockSlab && target.getBooleanValue(TOP_SLOT_PROPERTY) && this.isSameType((BlockSlab)target)) {
                this.getLevel().setBlock((Vector3)target, this.getCurrentState().withBlockId(this.doubleSlab).getBlock(target), true);
                return true;
            }
            if (block instanceof BlockSlab && this.isSameType((BlockSlab)block)) {
                this.getLevel().setBlock((Vector3)block, this.getCurrentState().withBlockId(this.doubleSlab).getBlock(target), true);
                return true;
            }
            this.setOnTop(true);
        } else if (face == BlockFace.UP) {
            if (target instanceof BlockSlab && !target.getBooleanValue(TOP_SLOT_PROPERTY) && this.isSameType((BlockSlab)target)) {
                this.getLevel().setBlock((Vector3)target, this.getCurrentState().withBlockId(this.doubleSlab).getBlock(target), true);
                return true;
            }
            if (block instanceof BlockSlab && this.isSameType((BlockSlab)block)) {
                this.getLevel().setBlock((Vector3)block, this.getCurrentState().withBlockId(this.doubleSlab).getBlock(target), true);
                return true;
            }
        } else {
            if (block instanceof BlockSlab) {
                if (this.isSameType((BlockSlab)block)) {
                    this.getLevel().setBlock((Vector3)block, this.getCurrentState().withBlockId(this.doubleSlab).getBlock(block), true);
                    return true;
                }
                return false;
            }
            if (fy > 0.5) {
                this.setOnTop(true);
            }
        }
        if (block instanceof BlockSlab && !this.isSameType((BlockSlab)block)) {
            return false;
        }
        this.getLevel().setBlock((Vector3)block, this, true, true);
        return true;
    }
}

