/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.entity.item.EntityItem;
import cn.nukkit.event.block.ItemFrameDropItemEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.item.MinecraftItemID;
import cn.nukkit.item.RuntimeItems;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;

public class BlockEntityItemFrame
extends BlockEntitySpawnable {
    public BlockEntityItemFrame(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        if (!this.namedTag.contains("Item")) {
            this.namedTag.putCompound("Item", NBTIO.putItemHelper(new ItemBlock(Block.get(0))));
        }
        if (!this.namedTag.contains("ItemRotation")) {
            this.namedTag.putByte("ItemRotation", 0);
        }
        if (!this.namedTag.contains("ItemDropChance")) {
            this.namedTag.putFloat("ItemDropChance", 1.0f);
        }
        this.level.updateComparatorOutputLevel(this);
        super.initBlockEntity();
    }

    @Override
    public String getName() {
        return "Item Frame";
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.getBlock().getId() == 199;
    }

    public int getItemRotation() {
        return this.namedTag.getByte("ItemRotation");
    }

    public void setItemRotation(int itemRotation) {
        this.namedTag.putByte("ItemRotation", itemRotation);
        this.level.updateComparatorOutputLevel(this);
        this.setDirty();
    }

    public Item getItem() {
        CompoundTag NBTTag = this.namedTag.getCompound("Item");
        return NBTIO.getItemHelper(NBTTag);
    }

    public void setItem(Item item) {
        this.setItem(item, true);
    }

    public void setItem(Item item, boolean setChanged) {
        this.namedTag.putCompound("Item", NBTIO.putItemHelper(item));
        if (setChanged) {
            this.setDirty();
        }
        this.level.updateComparatorOutputLevel(this);
    }

    public float getItemDropChance() {
        return this.namedTag.getFloat("ItemDropChance");
    }

    public void setItemDropChance(float chance) {
        this.namedTag.putFloat("ItemDropChance", chance);
    }

    @Override
    public void setDirty() {
        this.spawnToAll();
        super.setDirty();
    }

    @Override
    public CompoundTag getSpawnCompound() {
        if (!this.namedTag.contains("Item")) {
            this.setItem(new ItemBlock(Block.get(0)), false);
        }
        Item item = this.getItem();
        CompoundTag tag = new CompoundTag().putString("id", "ItemFrame").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        if (!item.isNull()) {
            CompoundTag itemTag = NBTIO.putItemHelper(item);
            int networkFullId = item.getNetworkFullId();
            int networkDamage = (networkFullId & 1) == 1 ? 0 : item.getDamage();
            String namespacedId = RuntimeItems.getRuntimeMapping().getNamespacedIdByNetworkId(RuntimeItems.getNetworkId(networkFullId));
            if (namespacedId != null) {
                itemTag.remove("id");
                itemTag.putShort("Damage", networkDamage);
                itemTag.putString("Name", namespacedId);
            }
            tag.putCompound("Item", itemTag).putByte("ItemRotation", this.getItemRotation());
        }
        return tag;
    }

    public int getAnalogOutput() {
        return this.getItem() == null || this.getItem().getId() == 0 ? 0 : this.getItemRotation() % 8 + 1;
    }

    @Since(value="1.4.0.0-PN")
    public boolean dropItem(Player player) {
        Item before = this.getItem();
        if (before == null || before.isNull()) {
            return false;
        }
        EntityItem drop = this.dropItemAndGetEntity(player);
        if (drop != null) {
            return true;
        }
        Item after = this.getItem();
        return after == null || after.isNull();
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public EntityItem dropItemAndGetEntity(@Nullable Player player) {
        Level level = this.getValidLevel();
        Item drop = this.getItem();
        if (drop.isNull()) {
            if (player != null) {
                this.spawnTo(player);
            }
            return null;
        }
        ItemFrameDropItemEvent event = new ItemFrameDropItemEvent(player, this.getLevelBlock(), this, drop);
        level.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            if (player != null) {
                this.spawnTo(player);
            }
            return null;
        }
        EntityItem itemEntity = null;
        if (this.getItemDropChance() > ThreadLocalRandom.current().nextFloat() && (itemEntity = level.dropAndGetItem(this.add(0.5, 0.25, 0.5), drop)) == null) {
            if (player != null) {
                this.spawnTo(player);
            }
            return null;
        }
        this.setItem(MinecraftItemID.AIR.get(0), true);
        this.setItemRotation(0);
        this.spawnToAll();
        level.addLevelEvent(this, 1042);
        return itemEntity;
    }
}

