/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockproperty.exception;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;

@ParametersAreNullableByDefault
@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class InvalidBlockPropertyPersistenceValueException
extends InvalidBlockPropertyException {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final String currentValue;
    @Nullable
    private final String invalidValue;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public InvalidBlockPropertyPersistenceValueException(@Nonnull BlockProperty<?> property, String currentValue, String invalidValue) {
        super(property, InvalidBlockPropertyPersistenceValueException.buildMessage(currentValue, invalidValue));
        this.currentValue = currentValue;
        this.invalidValue = invalidValue;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public InvalidBlockPropertyPersistenceValueException(@Nonnull BlockProperty<?> property, String currentValue, String invalidValue, String message) {
        super(property, InvalidBlockPropertyPersistenceValueException.buildMessage(currentValue, invalidValue) + ". " + message);
        this.currentValue = currentValue;
        this.invalidValue = invalidValue;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public InvalidBlockPropertyPersistenceValueException(@Nonnull BlockProperty<?> property, String currentValue, String invalidValue, String message, Throwable cause) {
        super(property, InvalidBlockPropertyPersistenceValueException.buildMessage(currentValue, invalidValue) + ". " + message, cause);
        this.currentValue = currentValue;
        this.invalidValue = invalidValue;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public InvalidBlockPropertyPersistenceValueException(@Nonnull BlockProperty<?> property, String currentValue, String invalidValue, Throwable cause) {
        super(property, InvalidBlockPropertyPersistenceValueException.buildMessage(currentValue, invalidValue), cause);
        this.currentValue = currentValue;
        this.invalidValue = invalidValue;
    }

    private static String buildMessage(Object currentValue, Object invalidValue) {
        return "Current Value: " + currentValue + ", Invalid Value: " + invalidValue;
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getCurrentValue() {
        return this.currentValue;
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getInvalidValue() {
        return this.invalidValue;
    }
}

