/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockstate;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.api.Unsigned;
import cn.nukkit.block.Block;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyException;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.IMutableBlockState;
import cn.nukkit.blockstate.MutableBlockState;
import cn.nukkit.blockstate.exception.InvalidBlockStateException;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.utils.Validation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;

@ParametersAreNonnullByDefault
@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class LongMutableBlockState
extends MutableBlockState {
    private long storage;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public LongMutableBlockState(int blockId, BlockProperties properties, long state) {
        super(blockId, properties);
        this.storage = state;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public LongMutableBlockState(int blockId, BlockProperties properties) {
        this(blockId, properties, 0L);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setDataStorage(@Nonnegative Number storage) {
        long state;
        Class<?> c = storage.getClass();
        if (c == Long.class || c == Integer.class || c == Short.class || c == Byte.class) {
            state = storage.longValue();
        } else {
            try {
                state = new BigDecimal(storage.toString()).longValueExact();
            }
            catch (ArithmeticException | NumberFormatException e) {
                throw IMutableBlockState.handleUnsupportedStorageType(this.getBlockId(), storage, e);
            }
        }
        this.validate(state);
        this.storage = state;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setDataStorageFromInt(@Nonnegative int storage) {
        long state = storage;
        this.validate(state);
        this.storage = state;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    void setDataStorageWithoutValidation(Number storage) {
        this.storage = storage.longValue();
    }

    @Override
    public void validate() {
        this.validate(this.storage);
    }

    private void validate(long state) {
        if (state == 0L) {
            return;
        }
        Validation.checkPositive("state", state);
        BlockProperties properties = this.properties;
        int bitLength = NukkitMath.bitLength(state);
        if (bitLength > properties.getBitSize()) {
            throw new InvalidBlockStateException(BlockState.of(this.getBlockId(), state), "The state have more data bits than specified in the properties. Bits: " + bitLength + ", Max: " + properties.getBitSize());
        }
        try {
            for (String name : properties.getNames()) {
                BlockProperty<?> property = properties.getBlockProperty(name);
                property.validateMeta(state, properties.getOffset(name));
            }
        }
        catch (InvalidBlockPropertyException e) {
            throw new InvalidBlockStateException(BlockState.of(this.getBlockId(), state), (Throwable)e);
        }
    }

    @Override
    @Nonnegative
    @Deprecated
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="getDataStorage()")
    public int getLegacyDamage() {
        return (int)(this.storage & (long)Block.DATA_MASK);
    }

    @Override
    @Deprecated
    @Unsigned
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="getDataStorage()")
    public int getBigDamage() {
        return (int)(this.storage & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    @Nonnegative
    @Deprecated
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="getDataStorage()")
    public int getSignedBigDamage() {
        return (int)(this.storage & Integer.MAX_VALUE);
    }

    @Override
    @Nonnegative
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BigInteger getHugeDamage() {
        return BigInteger.valueOf(this.storage);
    }

    @Override
    @Nonnegative
    @Nonnull
    public Number getDataStorage() {
        return this.storage;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean isDefaultState() {
        return this.storage == 0L;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setPropertyValue(String propertyName, @Nullable Serializable value) {
        this.storage = this.properties.setValue(this.storage, propertyName, value);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setBooleanValue(String propertyName, boolean value) {
        this.storage = this.properties.setBooleanValue(this.storage, propertyName, value);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setIntValue(String propertyName, int value) {
        this.storage = this.properties.setIntValue(this.storage, propertyName, value);
    }

    @Override
    @Nonnull
    public Serializable getPropertyValue(String propertyName) {
        return this.properties.getValue(this.storage, propertyName);
    }

    @Override
    public int getIntValue(String propertyName) {
        return this.properties.getIntValue(this.storage, propertyName);
    }

    @Override
    public boolean getBooleanValue(String propertyName) {
        return this.properties.getBooleanValue(this.storage, propertyName);
    }

    @Override
    @Nonnull
    public String getPersistenceValue(String propertyName) {
        return this.properties.getPersistenceValue(this.storage, propertyName);
    }

    @Override
    @Nonnull
    public BlockState getCurrentState() {
        return BlockState.of(this.blockId, this.storage);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getExactIntStorage() {
        int bits = this.getBitSize();
        if (bits > 32) {
            throw new ArithmeticException(this.storage + " can't be stored in an 32 bits integer. It has " + bits + " bits");
        }
        return (int)this.storage;
    }

    @Override
    @Nonnull
    public LongMutableBlockState copy() {
        return new LongMutableBlockState(this.getBlockId(), this.properties, this.storage);
    }

    @Override
    @Generated
    public String toString() {
        return "LongMutableBlockState(super=" + super.toString() + ", storage=" + this.storage + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LongMutableBlockState)) {
            return false;
        }
        LongMutableBlockState other = (LongMutableBlockState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.storage == other.storage;
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LongMutableBlockState;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $storage = this.storage;
        result = result * 59 + (int)($storage >>> 32 ^ $storage);
        return result;
    }
}

