/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockstate;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.IBlockState;
import cn.nukkit.blockstate.IMutableBlockState;
import cn.nukkit.blockstate.exception.InvalidBlockStateException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;

@ParametersAreNonnullByDefault
@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public abstract class MutableBlockState
implements IMutableBlockState {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected final int blockId;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected final BlockProperties properties;

    MutableBlockState(int blockId, BlockProperties properties) {
        this.blockId = blockId;
        this.properties = properties;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    void setDataStorageWithoutValidation(Number storage) {
        this.setDataStorage(storage);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setState(IBlockState state) throws InvalidBlockStateException {
        if (state.getBlockId() == this.getBlockId()) {
            if (BlockState.class == state.getClass() && ((BlockState)state).isCachedValidationValid()) {
                this.setDataStorageWithoutValidation(state.getDataStorage());
            } else {
                this.setDataStorage(state.getDataStorage());
            }
        } else {
            IMutableBlockState.super.setState(state);
        }
    }

    @Override
    @Nonnull
    public final BlockProperties getProperties() {
        return this.properties;
    }

    @Override
    @Nonnegative
    public final int getBlockId() {
        return this.blockId;
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="the BlockState itself")
    public final int getFullId() {
        return IMutableBlockState.super.getFullId();
    }

    @Override
    @Deprecated
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="the BlockState itself")
    public final long getBigId() {
        return IMutableBlockState.super.getBigId();
    }

    @Override
    public final int getBitSize() {
        return this.getProperties().getBitSize();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public abstract void validate();

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public abstract MutableBlockState copy();

    @Generated
    public String toString() {
        return "MutableBlockState(blockId=" + this.getBlockId() + ", properties=" + this.getProperties() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MutableBlockState)) {
            return false;
        }
        MutableBlockState other = (MutableBlockState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBlockId() != other.getBlockId()) {
            return false;
        }
        BlockProperties this$properties = this.getProperties();
        BlockProperties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MutableBlockState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBlockId();
        BlockProperties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }
}

