/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command.data;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.command.data.CommandEnum;
import cn.nukkit.command.data.CommandParamType;
import cn.nukkit.item.Item;
import java.util.ArrayList;

public class CommandParameter {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final CommandParameter[] EMPTY_ARRAY = new CommandParameter[0];
    public String name;
    public CommandParamType type;
    public boolean optional;
    public byte options = 0;
    public CommandEnum enumData;
    public String postFix;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Removed from Cloudburst Nukkit")
    @PowerNukkitOnly(value="Re-added for backward compatibility")
    public static final String ARG_TYPE_STRING = "string";
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Removed from Cloudburst Nukkit")
    @PowerNukkitOnly(value="Re-added for backward compatibility")
    public static final String ARG_TYPE_STRING_ENUM = "stringenum";
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Removed from Cloudburst Nukkit")
    @PowerNukkitOnly(value="Re-added for backward compatibility")
    public static final String ARG_TYPE_BOOL = "bool";
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Removed from Cloudburst Nukkit")
    @PowerNukkitOnly(value="Re-added for backward compatibility")
    public static final String ARG_TYPE_TARGET = "target";
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Removed from Cloudburst Nukkit")
    @PowerNukkitOnly(value="Re-added for backward compatibility")
    public static final String ARG_TYPE_PLAYER = "target";
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Removed from Cloudburst Nukkit")
    @PowerNukkitOnly(value="Re-added for backward compatibility")
    public static final String ARG_TYPE_BLOCK_POS = "blockpos";
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Removed from Cloudburst Nukkit")
    @PowerNukkitOnly(value="Re-added for backward compatibility")
    public static final String ARG_TYPE_RAW_TEXT = "rawtext";
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Removed from Cloudburst Nukkit")
    @PowerNukkitOnly(value="Re-added for backward compatibility")
    public static final String ARG_TYPE_INT = "int";
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Removed from Cloudburst Nukkit")
    @PowerNukkitOnly(value="Re-added for backward compatibility")
    public static final String ENUM_TYPE_ITEM_LIST = "Item";
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Removed from Cloudburst Nukkit")
    @PowerNukkitOnly(value="Re-added for backward compatibility")
    public static final String ENUM_TYPE_BLOCK_LIST = "blockType";
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Removed from Cloudburst Nukkit")
    @PowerNukkitOnly(value="Re-added for backward compatibility")
    public static final String ENUM_TYPE_COMMAND_LIST = "commandName";
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Removed from Cloudburst Nukkit")
    @PowerNukkitOnly(value="Re-added for backward compatibility")
    public static final String ENUM_TYPE_ENCHANTMENT_LIST = "enchantmentType";
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Removed from Cloudburst Nukkit")
    @PowerNukkitOnly(value="Re-added for backward compatibility")
    public static final String ENUM_TYPE_ENTITY_LIST = "entityType";
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Removed from Cloudburst Nukkit")
    @PowerNukkitOnly(value="Re-added for backward compatibility")
    public static final String ENUM_TYPE_EFFECT_LIST = "effectType";
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Removed from Cloudburst Nukkit")
    @PowerNukkitOnly(value="Re-added for backward compatibility")
    public static final String ENUM_TYPE_PARTICLE_LIST = "particleType";

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Deprecated by Cloudburst Nukkit", replaceWith="newType(String, boolean, CommandParamType)")
    public CommandParameter(String name, String type, boolean optional) {
        this(name, CommandParameter.fromString(type), optional);
    }

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Deprecated by Cloudburst Nukkit", replaceWith="newType(String, boolean, CommandParamType)")
    public CommandParameter(String name, CommandParamType type, boolean optional) {
        this.name = name;
        this.type = type;
        this.optional = optional;
    }

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Deprecated by Cloudburst Nukkit", replaceWith="newType(String, boolean, CommandParamType)")
    public CommandParameter(String name, boolean optional) {
        this(name, CommandParamType.RAWTEXT, optional);
    }

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Deprecated by Cloudburst Nukkit", replaceWith="newType(String, CommandParamType)")
    public CommandParameter(String name) {
        this(name, false);
    }

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Deprecated by Cloudburst Nukkit", replaceWith="newEnum(String, boolean, String)")
    public CommandParameter(String name, boolean optional, String enumType) {
        this.name = name;
        this.type = CommandParamType.RAWTEXT;
        this.optional = optional;
        this.enumData = new CommandEnum(enumType, ENUM_TYPE_ITEM_LIST.equals(enumType) ? Item.getItemList() : new ArrayList());
    }

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Deprecated by Cloudburst Nukkit", replaceWith="newEnum(String, boolean, String[])")
    public CommandParameter(String name, boolean optional, String[] enumValues) {
        this.name = name;
        this.type = CommandParamType.RAWTEXT;
        this.optional = optional;
        this.enumData = new CommandEnum(name + "Enums", enumValues);
    }

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Deprecated by Cloudburst Nukkit", replaceWith="newEnum(String, String)")
    public CommandParameter(String name, String enumType) {
        this(name, false, enumType);
    }

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Deprecated by Cloudburst Nukkit", replaceWith="newEnum(String, String[])")
    public CommandParameter(String name, String[] enumValues) {
        this(name, false, enumValues);
    }

    private CommandParameter(String name, boolean optional, CommandParamType type, CommandEnum enumData, String postFix) {
        this.name = name;
        this.optional = optional;
        this.type = type;
        this.enumData = enumData;
        this.postFix = postFix;
    }

    @Since(value="1.4.0.0-PN")
    public static CommandParameter newType(String name, CommandParamType type) {
        return CommandParameter.newType(name, false, type);
    }

    @Since(value="1.4.0.0-PN")
    public static CommandParameter newType(String name, boolean optional, CommandParamType type) {
        return new CommandParameter(name, optional, type, null, null);
    }

    @Since(value="1.4.0.0-PN")
    public static CommandParameter newEnum(String name, String[] values) {
        return CommandParameter.newEnum(name, false, values);
    }

    @Since(value="1.4.0.0-PN")
    public static CommandParameter newEnum(String name, boolean optional, String[] values) {
        return CommandParameter.newEnum(name, optional, new CommandEnum(name + "Enums", values));
    }

    @Since(value="1.4.0.0-PN")
    public static CommandParameter newEnum(String name, String type) {
        return CommandParameter.newEnum(name, false, type);
    }

    @Since(value="1.4.0.0-PN")
    public static CommandParameter newEnum(String name, boolean optional, String type) {
        return CommandParameter.newEnum(name, optional, new CommandEnum(type, new ArrayList<String>()));
    }

    @Since(value="1.4.0.0-PN")
    public static CommandParameter newEnum(String name, CommandEnum data) {
        return CommandParameter.newEnum(name, false, data);
    }

    @Since(value="1.4.0.0-PN")
    public static CommandParameter newEnum(String name, boolean optional, CommandEnum data) {
        return new CommandParameter(name, optional, CommandParamType.RAWTEXT, data, null);
    }

    @Since(value="1.4.0.0-PN")
    public static CommandParameter newPostfix(String name, String postfix) {
        return CommandParameter.newPostfix(name, false, postfix);
    }

    @Since(value="1.4.0.0-PN")
    public static CommandParameter newPostfix(String name, boolean optional, String postfix) {
        return new CommandParameter(name, optional, CommandParamType.RAWTEXT, null, postfix);
    }

    protected static CommandParamType fromString(String param) {
        switch (param) {
            case "string": 
            case "stringenum": {
                return CommandParamType.STRING;
            }
            case "target": {
                return CommandParamType.TARGET;
            }
            case "blockpos": {
                return CommandParamType.POSITION;
            }
            case "rawtext": {
                return CommandParamType.RAWTEXT;
            }
            case "int": {
                return CommandParamType.INT;
            }
        }
        return CommandParamType.RAWTEXT;
    }
}

