/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.entity.data.FloatEntityData;
import cn.nukkit.entity.data.IntEntityData;
import cn.nukkit.entity.data.LongEntityData;
import cn.nukkit.entity.data.ShortEntityData;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.EntityRegainHealthEvent;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.potion.Effect;
import cn.nukkit.potion.InstantEffect;
import cn.nukkit.potion.Potion;
import java.util.ArrayList;
import java.util.List;

public class EntityAreaEffectCloud
extends Entity {
    public static final int NETWORK_ID = 95;
    protected int reapplicationDelay;
    protected int durationOnUse;
    protected float initialRadius;
    protected float radiusOnUse;
    protected int nextApply;
    public List<Effect> cloudEffects;
    private int lastAge;

    public EntityAreaEffectCloud(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    public int getWaitTime() {
        return this.getDataPropertyInt(DATA_AREA_EFFECT_CLOUD_WAITING);
    }

    public void setWaitTime(int waitTime) {
        this.setWaitTime(waitTime, true);
    }

    public void setWaitTime(int waitTime, boolean send) {
        this.setDataProperty(new IntEntityData(DATA_AREA_EFFECT_CLOUD_WAITING, waitTime), send);
    }

    public int getPotionId() {
        return this.getDataPropertyShort(DATA_POTION_AUX_VALUE);
    }

    public void setPotionId(int potionId) {
        this.setPotionId(potionId, true);
    }

    public void setPotionId(int potionId, boolean send) {
        this.setDataProperty(new ShortEntityData(DATA_POTION_AUX_VALUE, potionId & 0xFFFF), send);
    }

    public void recalculatePotionColor() {
        this.recalculatePotionColor(true);
    }

    public void recalculatePotionColor(boolean send) {
        int b;
        int g;
        int r;
        int a;
        if (this.namedTag.contains("ParticleColor")) {
            int color = this.namedTag.getInt("ParticleColor");
            a = (color & 0xFF000000) >> 24;
            r = (color & 0xFF0000) >> 16;
            g = (color & 0xFF00) >> 8;
            b = color & 0xFF;
        } else {
            a = 255;
            Effect effect = Potion.getEffect(this.getPotionId(), true);
            if (effect == null) {
                r = 40;
                g = 40;
                b = 255;
            } else {
                int[] colors = effect.getColor();
                r = colors[0];
                g = colors[1];
                b = colors[2];
            }
        }
        this.setPotionColor(a, r, g, b, send);
    }

    public int getPotionColor() {
        return this.getDataPropertyInt(DATA_POTION_COLOR);
    }

    public void setPotionColor(int alpha, int red, int green, int blue, boolean send) {
        this.setPotionColor((alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF, send);
    }

    public void setPotionColor(int argp) {
        this.setPotionColor(argp, true);
    }

    public void setPotionColor(int argp, boolean send) {
        this.setDataProperty(new IntEntityData(DATA_POTION_COLOR, argp), send);
    }

    public int getPickupCount() {
        return this.getDataPropertyInt(DATA_PICKUP_COUNT);
    }

    public void setPickupCount(int pickupCount) {
        this.setPickupCount(pickupCount, true);
    }

    public void setPickupCount(int pickupCount, boolean send) {
        this.setDataProperty(new IntEntityData(DATA_PICKUP_COUNT, pickupCount), send);
    }

    public float getRadiusChangeOnPickup() {
        return this.getDataPropertyFloat(DATA_CHANGE_ON_PICKUP);
    }

    public void setRadiusChangeOnPickup(float radiusChangeOnPickup) {
        this.setRadiusChangeOnPickup(radiusChangeOnPickup, true);
    }

    public void setRadiusChangeOnPickup(float radiusChangeOnPickup, boolean send) {
        this.setDataProperty(new FloatEntityData(DATA_CHANGE_ON_PICKUP, radiusChangeOnPickup), send);
    }

    public float getRadiusPerTick() {
        return this.getDataPropertyFloat(DATA_CHANGE_RATE);
    }

    public void setRadiusPerTick(float radiusPerTick) {
        this.setRadiusPerTick(radiusPerTick, true);
    }

    public void setRadiusPerTick(float radiusPerTick, boolean send) {
        this.setDataProperty(new FloatEntityData(DATA_CHANGE_RATE, radiusPerTick), send);
    }

    public long getSpawnTime() {
        return this.getDataPropertyInt(DATA_SPAWN_TIME);
    }

    public void setSpawnTime(long spawnTime) {
        this.setSpawnTime(spawnTime, true);
    }

    public void setSpawnTime(long spawnTime, boolean send) {
        this.setDataProperty(new LongEntityData(DATA_SPAWN_TIME, spawnTime), send);
    }

    public int getDuration() {
        return this.getDataPropertyInt(DATA_DURATION);
    }

    public void setDuration(int duration) {
        this.setDuration(duration, true);
    }

    public void setDuration(int duration, boolean send) {
        this.setDataProperty(new IntEntityData(DATA_DURATION, duration), send);
    }

    public float getRadius() {
        return this.getDataPropertyFloat(DATA_AREA_EFFECT_CLOUD_RADIUS);
    }

    public void setRadius(float radius) {
        this.setRadius(radius, true);
    }

    public void setRadius(float radius, boolean send) {
        this.setDataProperty(new FloatEntityData(DATA_AREA_EFFECT_CLOUD_RADIUS, radius), send);
    }

    public int getParticleId() {
        return this.getDataPropertyInt(DATA_AREA_EFFECT_CLOUD_PARTICLE_ID);
    }

    public void setParticleId(int particleId) {
        this.setParticleId(particleId, true);
    }

    public void setParticleId(int particleId, boolean send) {
        this.setDataProperty(new IntEntityData(DATA_AREA_EFFECT_CLOUD_PARTICLE_ID, particleId), send);
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        this.invulnerable = true;
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_FIRE_IMMUNE, true);
        this.setDataFlag(DATA_FLAGS, DATA_FLAG_IMMOBILE, true);
        this.setDataProperty(new ShortEntityData(DATA_AREA_EFFECT_CLOUD_PARTICLE_ID, 32), false);
        this.setDataProperty(new LongEntityData(DATA_SPAWN_TIME, this.level.getCurrentTick()), false);
        this.setDataProperty(new IntEntityData(DATA_PICKUP_COUNT, 0), false);
        this.cloudEffects = new ArrayList<Effect>(1);
        for (CompoundTag effectTag : this.namedTag.getList("mobEffects", CompoundTag.class).getAll()) {
            Effect effect = Effect.getEffect(effectTag.getByte("Id")).setAmbient(effectTag.getBoolean("Ambient")).setAmplifier(effectTag.getByte("Amplifier")).setVisible(effectTag.getBoolean("DisplayOnScreenTextureAnimation")).setDuration(effectTag.getInt("Duration"));
            this.cloudEffects.add(effect);
        }
        int displayedPotionId = this.namedTag.getShort("PotionId");
        this.setPotionId(displayedPotionId, false);
        this.recalculatePotionColor();
        if (this.namedTag.contains("Duration")) {
            this.setDuration(this.namedTag.getInt("Duration"), false);
        } else {
            this.setDuration(600, false);
        }
        this.durationOnUse = this.namedTag.contains("DurationOnUse") ? this.namedTag.getInt("DurationOnUse") : 0;
        this.reapplicationDelay = this.namedTag.contains("ReapplicationDelay") ? this.namedTag.getInt("ReapplicationDelay") : 0;
        this.initialRadius = this.namedTag.contains("InitialRadius") ? this.namedTag.getFloat("InitialRadius") : 3.0f;
        if (this.namedTag.contains("Radius")) {
            this.setRadius(this.namedTag.getFloat("Radius"), false);
        } else {
            this.setRadius(this.initialRadius, false);
        }
        if (this.namedTag.contains("RadiusChangeOnPickup")) {
            this.setRadiusChangeOnPickup(this.namedTag.getFloat("RadiusChangeOnPickup"), false);
        } else {
            this.setRadiusChangeOnPickup(-0.5f, false);
        }
        this.radiusOnUse = this.namedTag.contains("RadiusOnUse") ? this.namedTag.getFloat("RadiusOnUse") : -0.5f;
        if (this.namedTag.contains("RadiusPerTick")) {
            this.setRadiusPerTick(this.namedTag.getFloat("RadiusPerTick"), false);
        } else {
            this.setRadiusPerTick(-0.005f, false);
        }
        if (this.namedTag.contains("WaitTime")) {
            this.setWaitTime(this.namedTag.getInt("WaitTime"), false);
        } else {
            this.setWaitTime(10, false);
        }
        this.setMaxHealth(1);
        this.setHealth(1.0f);
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        return false;
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        ListTag<CompoundTag> effectsTag = new ListTag<CompoundTag>("mobEffects");
        for (Effect effect : this.cloudEffects) {
            effectsTag.add(new CompoundTag().putByte("Id", effect.getId()).putBoolean("Ambient", effect.isAmbient()).putByte("Amplifier", effect.getAmplifier()).putBoolean("DisplayOnScreenTextureAnimation", effect.isVisible()).putInt("Duration", effect.getDuration()));
        }
        this.namedTag.putList(effectsTag);
        this.namedTag.putInt("ParticleColor", this.getPotionColor());
        this.namedTag.putShort("PotionId", this.getPotionId());
        this.namedTag.putInt("Duration", this.getDuration());
        this.namedTag.putInt("DurationOnUse", this.durationOnUse);
        this.namedTag.putInt("ReapplicationDelay", this.reapplicationDelay);
        this.namedTag.putFloat("Radius", this.getRadius());
        this.namedTag.putFloat("RadiusChangeOnPickup", this.getRadiusChangeOnPickup());
        this.namedTag.putFloat("RadiusOnUse", this.radiusOnUse);
        this.namedTag.putFloat("RadiusPerTick", this.getRadiusPerTick());
        this.namedTag.putInt("WaitTime", this.getWaitTime());
        this.namedTag.putFloat("InitialRadius", this.initialRadius);
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        this.timing.startTiming();
        super.onUpdate(currentTick);
        boolean sendRadius = this.age % 10 == 0;
        int age = this.age;
        float radius = this.getRadius();
        int waitTime = this.getWaitTime();
        if (age < waitTime) {
            radius = this.initialRadius;
        } else if (age > waitTime + this.getDuration()) {
            this.kill();
        } else {
            int tickDiff = age - this.lastAge;
            radius += this.getRadiusPerTick() * (float)tickDiff;
            if ((this.nextApply -= tickDiff) <= 0) {
                this.nextApply = this.reapplicationDelay + 10;
                Entity[] collidingEntities = this.level.getCollidingEntities(this.getBoundingBox());
                if (collidingEntities.length > 0) {
                    radius += this.radiusOnUse;
                    this.radiusOnUse /= 2.0f;
                    this.setDuration(this.getDuration() + this.durationOnUse);
                    for (Entity collidingEntity : collidingEntities) {
                        if (collidingEntity == this || !(collidingEntity instanceof EntityLiving)) continue;
                        for (Effect effect : this.cloudEffects) {
                            if (effect instanceof InstantEffect) {
                                boolean damage = false;
                                if (effect.getId() == 7) {
                                    damage = true;
                                }
                                if (collidingEntity.isUndead()) {
                                    boolean bl = damage = !damage;
                                }
                                if (damage) {
                                    collidingEntity.attack(new EntityDamageByEntityEvent((Entity)this, collidingEntity, EntityDamageEvent.DamageCause.MAGIC, (float)(0.5 * (double)(6 << effect.getAmplifier() + 1))));
                                    continue;
                                }
                                collidingEntity.heal(new EntityRegainHealthEvent(collidingEntity, (float)(0.5 * (double)(4 << effect.getAmplifier() + 1)), 2));
                                continue;
                            }
                            collidingEntity.addEffect(effect);
                        }
                    }
                }
            }
        }
        this.lastAge = age;
        if ((double)radius <= 1.5 && age >= waitTime) {
            this.setRadius(radius, false);
            this.kill();
        } else {
            this.setRadius(radius, sendRadius);
        }
        float height = this.getHeight();
        this.boundingBox.setBounds(this.x - (double)radius, this.y - (double)height, this.z - (double)radius, this.x + (double)radius, this.y + (double)height, this.z + (double)radius);
        this.setDataProperty(new FloatEntityData(DATA_BOUNDING_BOX_HEIGHT, height), false);
        this.setDataProperty(new FloatEntityData(DATA_BOUNDING_BOX_WIDTH, radius), false);
        this.timing.stopTiming();
        return true;
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return entity instanceof EntityLiving;
    }

    @Override
    public float getHeight() {
        return 0.3f + this.getRadius() / 2.0f;
    }

    @Override
    public float getWidth() {
        return this.getRadius();
    }

    @Override
    public float getLength() {
        return this.getRadius();
    }

    @Override
    protected float getGravity() {
        return 0.0f;
    }

    @Override
    protected float getDrag() {
        return 0.0f;
    }

    @Override
    public int getNetworkId() {
        return 95;
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public String getOriginalName() {
        return "Area Effect Cloud";
    }
}

