/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.entity.Entity;
import cn.nukkit.inventory.BaseInventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.item.Item;
import cn.nukkit.network.protocol.InventoryContentPacket;
import cn.nukkit.network.protocol.InventorySlotPacket;
import cn.nukkit.network.protocol.MobArmorEquipmentPacket;
import java.util.HashSet;
import java.util.Set;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class EntityArmorInventory
extends BaseInventory {
    private final Entity entity;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final int SLOT_HEAD = 0;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final int SLOT_CHEST = 1;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final int SLOT_LEGS = 2;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final int SLOT_FEET = 3;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public EntityArmorInventory(Entity entity) {
        super((InventoryHolder)((Object)entity), InventoryType.ENTITY_ARMOR);
        this.entity = entity;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public InventoryHolder getHolder() {
        return this.holder;
    }

    @Override
    public String getName() {
        return "Entity Armor";
    }

    @Override
    public int getSize() {
        return 4;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getHelmet() {
        return this.getItem(0);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getChestplate() {
        return this.getItem(1);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getLeggings() {
        return this.getItem(2);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getBoots() {
        return this.getItem(3);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setHelmet(Item item) {
        this.setItem(1, item);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setChestplate(Item item) {
        this.setItem(1, item);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setLeggings(Item item) {
        this.setItem(2, item);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setBoots(Item item) {
        this.setItem(3, item);
    }

    @Override
    public void sendSlot(int index, Player ... players) {
        for (Player player : players) {
            this.sendSlot(index, player);
        }
    }

    @Override
    public void sendSlot(int index, Player player) {
        MobArmorEquipmentPacket mobArmorEquipmentPacket = new MobArmorEquipmentPacket();
        mobArmorEquipmentPacket.eid = this.entity.getId();
        mobArmorEquipmentPacket.slots = new Item[]{this.getHelmet(), this.getChestplate(), this.getLeggings(), this.getBoots()};
        if (player == this.holder) {
            InventorySlotPacket inventorySlotPacket = new InventorySlotPacket();
            inventorySlotPacket.inventoryId = player.getWindowId(this);
            inventorySlotPacket.slot = index;
            inventorySlotPacket.item = this.getItem(index);
            player.dataPacket(inventorySlotPacket);
        } else {
            player.dataPacket(mobArmorEquipmentPacket);
        }
    }

    @Override
    public void sendContents(Player ... players) {
        for (Player player : players) {
            this.sendContents(player);
        }
    }

    @Override
    public void sendContents(Player player) {
        MobArmorEquipmentPacket mobArmorEquipmentPacket = new MobArmorEquipmentPacket();
        mobArmorEquipmentPacket.eid = this.entity.getId();
        mobArmorEquipmentPacket.slots = new Item[]{this.getHelmet(), this.getChestplate(), this.getLeggings(), this.getBoots()};
        if (player == this.holder) {
            InventoryContentPacket inventoryContentPacket = new InventoryContentPacket();
            inventoryContentPacket.inventoryId = player.getWindowId(this);
            inventoryContentPacket.slots = new Item[]{this.getHelmet(), this.getChestplate(), this.getLeggings(), this.getBoots()};
            player.dataPacket(inventoryContentPacket);
        } else {
            player.dataPacket(mobArmorEquipmentPacket);
        }
    }

    @Override
    public void onOpen(Player who) {
        this.viewers.add(who);
    }

    @Override
    public void onClose(Player who) {
        this.viewers.remove(who);
    }

    @Override
    public Set<Player> getViewers() {
        HashSet<Player> viewers = new HashSet<Player>(this.viewers);
        viewers.addAll(this.entity.getViewers().values());
        return viewers;
    }
}

