/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.inventory.CraftingManager;
import cn.nukkit.inventory.Recipe;
import cn.nukkit.inventory.RecipeType;
import cn.nukkit.item.Item;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class SmithingRecipe
implements Recipe {
    private final Item equipment;
    private final Item ingredient;
    private final Item result;
    private final List<Item> ingredientsAggregate;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public SmithingRecipe(Item equipment, Item ingredient, Item result) {
        this.equipment = equipment;
        this.ingredient = ingredient;
        this.result = result;
        ArrayList<Item> aggregation = new ArrayList<Item>(2);
        for (Item item : new Item[]{equipment, ingredient}) {
            if (item.getCount() < 1) {
                throw new IllegalArgumentException("Recipe Ingredient amount was not 1 (value: " + item.getCount() + ")");
            }
            boolean found = false;
            for (Item existingIngredient : aggregation) {
                if (!existingIngredient.equals(item, item.hasMeta(), item.hasCompoundTag())) continue;
                existingIngredient.setCount(existingIngredient.getCount() + item.getCount());
                found = true;
                break;
            }
            if (found) continue;
            aggregation.add(item.clone());
        }
        aggregation.trimToSize();
        aggregation.sort(CraftingManager.recipeComparator);
        this.ingredientsAggregate = Collections.unmodifiableList(aggregation);
    }

    @Override
    public Item getResult() {
        return this.result;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getFinalResult(Item equip) {
        int maxDurability;
        Item finalResult = this.getResult().clone();
        if (equip.hasCompoundTag()) {
            finalResult.setCompoundTag(equip.getCompoundTag());
        }
        if ((maxDurability = finalResult.getMaxDurability()) <= 0 || equip.getMaxDurability() <= 0) {
            return finalResult;
        }
        int damage = equip.getDamage();
        if (damage <= 0) {
            return finalResult;
        }
        finalResult.setDamage(Math.min(maxDurability, damage));
        return finalResult;
    }

    @Override
    public void registerToCraftingManager(CraftingManager manager) {
        manager.registerSmithingRecipe(this);
    }

    @Override
    public RecipeType getType() {
        return RecipeType.SMITHING;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getEquipment() {
        return this.equipment;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getIngredient() {
        return this.ingredient;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public List<Item> getIngredientsAggregate() {
        return this.ingredientsAggregate;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean matchItems(List<Item> inputList) {
        return this.matchItems(inputList, 1);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean matchItems(List<Item> inputList, int multiplier) {
        ArrayList<Item> haveInputs = new ArrayList<Item>();
        for (Item item : inputList) {
            if (item.isNull()) continue;
            haveInputs.add(item.clone());
        }
        ArrayList<Item> needInputs = new ArrayList<Item>();
        if (multiplier != 1) {
            for (Item item : this.ingredientsAggregate) {
                if (item.isNull()) continue;
                Item itemClone = item.clone();
                itemClone.setCount(itemClone.getCount() * multiplier);
                needInputs.add(itemClone);
            }
        } else {
            for (Item item : this.ingredientsAggregate) {
                if (item.isNull()) continue;
                needInputs.add(item.clone());
            }
        }
        return Recipe.matchItemList(haveInputs, needInputs);
    }

    @Generated
    public String toString() {
        return "SmithingRecipe(equipment=" + this.getEquipment() + ", ingredient=" + this.getIngredient() + ", result=" + this.getResult() + ", ingredientsAggregate=" + this.getIngredientsAggregate() + ")";
    }
}

