/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.inventory.CraftingManager;
import cn.nukkit.inventory.Recipe;
import cn.nukkit.inventory.RecipeType;
import cn.nukkit.item.Item;
import java.util.UUID;
import lombok.Generated;

public class StonecutterRecipe
implements Recipe {
    private String recipeId;
    private final Item output;
    private long least;
    private long most;
    private final Item ingredient;
    private final int priority;

    public StonecutterRecipe(Item result, Item ingredient) {
        this(null, 10, result, ingredient);
    }

    public StonecutterRecipe(String recipeId, int priority, Item result, Item ingredient) {
        this.recipeId = recipeId;
        this.priority = priority;
        this.output = result.clone();
        if (ingredient.getCount() < 1) {
            throw new IllegalArgumentException("Recipe '" + recipeId + "' Ingredient amount was not 1 (value: " + ingredient.getCount() + ")");
        }
        this.ingredient = ingredient.clone();
    }

    @Override
    public Item getResult() {
        return this.output.clone();
    }

    public String getRecipeId() {
        return this.recipeId;
    }

    public UUID getId() {
        return new UUID(this.least, this.most);
    }

    public void setId(UUID uuid) {
        this.least = uuid.getLeastSignificantBits();
        this.most = uuid.getMostSignificantBits();
        if (this.recipeId == null) {
            this.recipeId = this.getId().toString();
        }
    }

    public Item getIngredient() {
        return this.ingredient.clone();
    }

    @Override
    public void registerToCraftingManager(CraftingManager manager) {
        manager.registerStonecutterRecipe(this);
    }

    @Override
    public RecipeType getType() {
        return RecipeType.STONECUTTER;
    }

    public int getPriority() {
        return this.priority;
    }

    @Generated
    public String toString() {
        return "StonecutterRecipe(recipeId=" + this.getRecipeId() + ", output=" + this.output + ", least=" + this.least + ", most=" + this.most + ", ingredient=" + this.getIngredient() + ", priority=" + this.getPriority() + ")";
    }
}

