/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item.enchantment;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.entity.Entity;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.item.enchantment.EnchantmentType;
import cn.nukkit.item.enchantment.sideeffect.SideEffect;
import cn.nukkit.item.enchantment.sideeffect.SideEffectCombust;
import javax.annotation.Nonnull;

public class EnchantmentFireAspect
extends Enchantment {
    protected EnchantmentFireAspect() {
        super(13, "fire", Enchantment.Rarity.RARE, EnchantmentType.SWORD);
    }

    @Override
    public int getMinEnchantAbility(int level) {
        return 10 + (level - 1) * 20;
    }

    @Override
    public int getMaxEnchantAbility(int level) {
        return super.getMinEnchantAbility(level) + 50;
    }

    @Override
    public int getMaxLevel() {
        return 2;
    }

    @Override
    @PowerNukkitDifference(since="1.5.1.0-PN", info="The entity combustion code was moved to SideEffectCombust, obtained by getAttackSideEffects(Entity, Entity)")
    public void doPostAttack(Entity attacker, Entity entity) {
        super.doPostAttack(attacker, entity);
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.1.0-PN")
    public SideEffect[] getAttackSideEffects(@Nonnull Entity attacker, @Nonnull Entity entity) {
        return new SideEffect[]{new SideEffectCombust(Math.max(entity.fireTicks / 20, this.getLevel() * 4))};
    }
}

