/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.lang;

import cn.nukkit.lang.TextContainer;
import cn.nukkit.lang.TranslationContainer;
import io.netty.util.internal.EmptyArrays;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseLang {
    @Generated
    private static final Logger log = LogManager.getLogger(BaseLang.class);
    public static final String FALLBACK_LANGUAGE = "eng";
    protected final String langName;
    protected Map<String, String> lang = new HashMap<String, String>();
    protected Map<String, String> fallbackLang = new HashMap<String, String>();

    public BaseLang(String lang) {
        this(lang, null);
    }

    public BaseLang(String lang, String path) {
        this(lang, path, FALLBACK_LANGUAGE);
    }

    public BaseLang(String lang, String path, String fallback) {
        boolean useFallback;
        this.langName = lang.toLowerCase();
        boolean bl = useFallback = !lang.equals(fallback);
        if (path == null) {
            path = "lang/";
            this.lang = this.loadLang(this.getClass().getClassLoader().getResourceAsStream(path + this.langName + "/lang.ini"));
            if (useFallback) {
                this.fallbackLang = this.loadLang(this.getClass().getClassLoader().getResourceAsStream(path + fallback + "/lang.ini"));
            }
        } else {
            this.lang = this.loadLang(path + this.langName + "/lang.ini");
            if (useFallback) {
                this.fallbackLang = this.loadLang(path + fallback + "/lang.ini");
            }
        }
        if (this.fallbackLang == null) {
            this.fallbackLang = this.lang;
        }
    }

    public Map<String, String> getLangMap() {
        return this.lang;
    }

    public Map<String, String> getFallbackLangMap() {
        return this.fallbackLang;
    }

    public String getName() {
        return this.get("language.name");
    }

    public String getLang() {
        return this.langName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, String> loadLang(String path) {
        try {
            File file = new File(path);
            if (!file.exists()) throw new FileNotFoundException();
            if (file.isDirectory()) {
                throw new FileNotFoundException();
            }
            try (FileInputStream stream = new FileInputStream(file);){
                Map<String, String> map = this.parseLang(new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8)));
                return map;
            }
        }
        catch (IOException e) {
            log.fatal("Failed to load language at {}", (Object)path, (Object)e);
            return null;
        }
    }

    protected Map<String, String> loadLang(InputStream stream) {
        try {
            return this.parseLang(new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            log.error("Failed to parse the language input stream", (Throwable)e);
            return null;
        }
    }

    private Map<String, String> parseLang(BufferedReader reader) throws IOException {
        String line;
        HashMap<String, String> d = new HashMap<String, String>();
        while ((line = reader.readLine()) != null) {
            String[] t;
            if ((line = line.trim()).isEmpty() || line.charAt(0) == '#' || (t = line.split("=", 2)).length < 2) continue;
            String key = t[0];
            String value = t[1];
            if (value.length() > 1 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                value = value.substring(1, value.length() - 1).replace("\\\"", "\"").replace("\\\\", "\\");
            }
            if (value.isEmpty()) continue;
            d.put(key, value);
        }
        return d;
    }

    public String translateString(String str) {
        return this.translateString(str, new String[0], (String)null);
    }

    public String translateString(String str, String ... params) {
        if (params != null) {
            return this.translateString(str, params, (String)null);
        }
        return this.translateString(str, EmptyArrays.EMPTY_STRINGS, (String)null);
    }

    public String translateString(String str, Object ... params) {
        if (params != null) {
            String[] paramsToString = new String[params.length];
            for (int i = 0; i < params.length; ++i) {
                paramsToString[i] = Objects.toString(params[i]);
            }
            return this.translateString(str, paramsToString, (String)null);
        }
        return this.translateString(str, EmptyArrays.EMPTY_STRINGS, (String)null);
    }

    public String translateString(String str, String param, String onlyPrefix) {
        return this.translateString(str, new String[]{param}, onlyPrefix);
    }

    public String translateString(String str, String[] params, String onlyPrefix) {
        String baseText = this.get(str);
        baseText = this.parseTranslation(baseText != null && (onlyPrefix == null || str.indexOf(onlyPrefix) == 0) ? baseText : str, onlyPrefix);
        for (int i = 0; i < params.length; ++i) {
            baseText = baseText.replace("{%" + i + "}", this.parseTranslation(String.valueOf(params[i])));
        }
        return baseText;
    }

    public String translate(TextContainer c) {
        String baseText = this.parseTranslation(c.getText());
        if (c instanceof TranslationContainer) {
            baseText = this.internalGet(c.getText());
            baseText = this.parseTranslation(baseText != null ? baseText : c.getText());
            for (int i = 0; i < ((TranslationContainer)c).getParameters().length; ++i) {
                baseText = baseText.replace("{%" + i + "}", this.parseTranslation(((TranslationContainer)c).getParameters()[i]));
            }
        }
        return baseText;
    }

    public String internalGet(String id) {
        if (this.lang.containsKey(id)) {
            return this.lang.get(id);
        }
        if (this.fallbackLang.containsKey(id)) {
            return this.fallbackLang.get(id);
        }
        return null;
    }

    public String get(String id) {
        if (this.lang.containsKey(id)) {
            return this.lang.get(id);
        }
        if (this.fallbackLang.containsKey(id)) {
            return this.fallbackLang.get(id);
        }
        return id;
    }

    protected String parseTranslation(String text) {
        return this.parseTranslation(text, null);
    }

    protected String parseTranslation(String text, String onlyPrefix) {
        StringBuilder newString = new StringBuilder();
        text = String.valueOf(text);
        String replaceString = null;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (replaceString != null) {
                char ord = c;
                if (ord >= '0' && ord <= '9' || ord >= 'A' && ord <= 'Z' || ord >= 'a' && ord <= 'z' || c == '.' || c == '-') {
                    replaceString = replaceString + String.valueOf(c);
                    continue;
                }
                String t = this.internalGet(replaceString.substring(1));
                if (t != null && (onlyPrefix == null || replaceString.indexOf(onlyPrefix) == 1)) {
                    newString.append(t);
                } else {
                    newString.append(replaceString);
                }
                replaceString = null;
                if (c == '%') {
                    replaceString = String.valueOf(c);
                    continue;
                }
                newString.append(c);
                continue;
            }
            if (c == '%') {
                replaceString = String.valueOf(c);
                continue;
            }
            newString.append(c);
        }
        if (replaceString != null) {
            String t = this.internalGet(replaceString.substring(1));
            if (t != null && (onlyPrefix == null || replaceString.indexOf(onlyPrefix) == 1)) {
                newString.append(t);
            } else {
                newString.append(replaceString);
            }
        }
        return newString.toString();
    }
}

