/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.updater;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.updater.Updater;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
class FrameUpdater
implements Updater {
    private final ChunkSection section;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public FrameUpdater(ChunkSection section) {
        this.section = section;
    }

    @Override
    public boolean update(int offsetX, int offsetY, int offsetZ, int x, int y, int z, BlockState state) {
        if (state.getBlockId() != 199) {
            return false;
        }
        return this.section.setBlockStateAtLayer(x, y, z, 0, state.withData(this.getNewData(state.getExactIntStorage())));
    }

    private int getNewData(int fromData) {
        switch (fromData) {
            case 0: {
                return 5;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 13;
            }
            case 5: {
                return 12;
            }
            case 6: {
                return 11;
            }
            case 7: {
                return 10;
            }
        }
        return fromData;
    }
}

