/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network;

import cn.nukkit.api.Since;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import javax.annotation.Nonnull;

@Since(value="1.4.0.0-PN")
public class LittleEndianByteBufInputStream
extends ByteBufInputStream {
    private final ByteBuf buffer;

    @Since(value="1.4.0.0-PN")
    public LittleEndianByteBufInputStream(@Nonnull ByteBuf buffer) {
        super(buffer);
        this.buffer = buffer;
    }

    public char readChar() throws IOException {
        return Character.reverseBytes(this.buffer.readChar());
    }

    public double readDouble() throws IOException {
        return this.buffer.readDoubleLE();
    }

    public float readFloat() throws IOException {
        return this.buffer.readFloatLE();
    }

    public short readShort() throws IOException {
        return this.buffer.readShortLE();
    }

    public int readUnsignedShort() throws IOException {
        return this.buffer.readUnsignedShortLE();
    }

    public long readLong() throws IOException {
        return this.buffer.readLongLE();
    }

    public int readInt() throws IOException {
        return this.buffer.readIntLE();
    }
}

