/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.network.protocol.DataPacket;
import java.util.UUID;
import org.powernukkit.version.Version;

@PowerNukkitOnly
@Since(value="1.5.2.0-PN")
public abstract class AbstractResourcePackDataPacket
extends DataPacket {
    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public abstract Version getPackVersion();

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public abstract void setPackVersion(Version var1);

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public abstract UUID getPackId();

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public abstract void setPackId(UUID var1);

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    protected void decodePackInfo() {
        String packInfo = this.getString();
        String[] packInfoParts = packInfo.split("_", 2);
        try {
            this.setPackId(UUID.fromString(packInfoParts[0]));
        }
        catch (IllegalArgumentException exception) {
            this.setPackId(null);
        }
        this.setPackVersion(packInfoParts.length > 1 ? new Version(packInfoParts[1]) : null);
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    protected void encodePackInfo() {
        String packInfo;
        UUID packId = this.getPackId();
        Version packVersion = this.getPackVersion();
        String string = packInfo = packId != null ? packId.toString() : new UUID(0L, 0L).toString();
        if (packVersion != null) {
            packInfo = packInfo + "_" + packVersion;
        }
        this.putString(packInfo);
    }
}

