/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.inventory.BlastFurnaceRecipe;
import cn.nukkit.inventory.BrewingRecipe;
import cn.nukkit.inventory.CampfireRecipe;
import cn.nukkit.inventory.CartographyRecipe;
import cn.nukkit.inventory.ContainerRecipe;
import cn.nukkit.inventory.FurnaceRecipe;
import cn.nukkit.inventory.MultiRecipe;
import cn.nukkit.inventory.Recipe;
import cn.nukkit.inventory.RecipeType;
import cn.nukkit.inventory.ShapedRecipe;
import cn.nukkit.inventory.ShapelessRecipe;
import cn.nukkit.inventory.SmeltingRecipe;
import cn.nukkit.inventory.SmokerRecipe;
import cn.nukkit.inventory.StonecutterRecipe;
import cn.nukkit.item.Item;
import cn.nukkit.network.protocol.DataPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;

public class CraftingDataPacket
extends DataPacket {
    public static final byte NETWORK_ID = 52;
    public static final String CRAFTING_TAG_CRAFTING_TABLE = "crafting_table";
    public static final String CRAFTING_TAG_CARTOGRAPHY_TABLE = "cartography_table";
    public static final String CRAFTING_TAG_STONECUTTER = "stonecutter";
    public static final String CRAFTING_TAG_FURNACE = "furnace";
    public static final String CRAFTING_TAG_CAMPFIRE = "campfire";
    public static final String CRAFTING_TAG_BLAST_FURNACE = "blast_furnace";
    public static final String CRAFTING_TAG_SMOKER = "smoker";
    private List<Recipe> entries = new ArrayList<Recipe>();
    private final List<BrewingRecipe> brewingEntries = new ArrayList<BrewingRecipe>();
    private final List<ContainerRecipe> containerEntries = new ArrayList<ContainerRecipe>();
    public boolean cleanRecipes;

    public void addShapelessRecipe(ShapelessRecipe ... recipe) {
        Collections.addAll(this.entries, recipe);
    }

    @PowerNukkitOnly
    public void addStonecutterRecipe(StonecutterRecipe ... recipes) {
        Collections.addAll(this.entries, recipes);
    }

    public void addShapedRecipe(ShapedRecipe ... recipe) {
        Collections.addAll(this.entries, recipe);
    }

    @PowerNukkitOnly
    public void addCartographyRecipe(CartographyRecipe ... recipe) {
        Stream.of(recipe).filter(r -> r.getRecipeId() != null).forEachOrdered(r -> this.entries.add((Recipe)r));
    }

    public void addFurnaceRecipe(FurnaceRecipe ... recipe) {
        Collections.addAll(this.entries, recipe);
    }

    @PowerNukkitOnly
    public void addSmokerRecipe(SmokerRecipe ... recipe) {
        Collections.addAll(this.entries, recipe);
    }

    @PowerNukkitOnly
    public void addBlastFurnaceRecipe(BlastFurnaceRecipe ... recipe) {
        Collections.addAll(this.entries, recipe);
    }

    @PowerNukkitOnly
    public void addCampfireRecipeRecipe(CampfireRecipe ... recipe) {
        Collections.addAll(this.entries, recipe);
    }

    @Since(value="1.4.0.0-PN")
    public void addMultiRecipe(MultiRecipe ... recipe) {
        Collections.addAll(this.entries, recipe);
    }

    public void addBrewingRecipe(BrewingRecipe ... recipe) {
        Collections.addAll(this.brewingEntries, recipe);
    }

    public void addContainerRecipe(ContainerRecipe ... recipe) {
        Collections.addAll(this.containerEntries, recipe);
    }

    @Override
    public DataPacket clean() {
        this.entries = new ArrayList<Recipe>();
        return super.clean();
    }

    @Override
    public void decode() {
    }

    @Override
    public void encode() {
        this.reset();
        this.putUnsignedVarInt(this.entries.size());
        int recipeNetworkId = 1;
        for (Recipe recipe : this.entries) {
            this.putVarInt(recipe.getType().networkType);
            block0 : switch (recipe.getType()) {
                case STONECUTTER: {
                    StonecutterRecipe stonecutter = (StonecutterRecipe)recipe;
                    this.putString(stonecutter.getRecipeId());
                    this.putUnsignedVarInt(1L);
                    this.putRecipeIngredient(stonecutter.getIngredient());
                    this.putUnsignedVarInt(1L);
                    this.putSlot(stonecutter.getResult(), true);
                    this.putUUID(stonecutter.getId());
                    this.putString(CRAFTING_TAG_STONECUTTER);
                    this.putVarInt(stonecutter.getPriority());
                    this.putUnsignedVarInt(recipeNetworkId++);
                    break;
                }
                case SHAPELESS: 
                case CARTOGRAPHY: 
                case SHULKER_BOX: {
                    ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
                    this.putString(shapeless.getRecipeId());
                    List<Item> ingredients = shapeless.getIngredientList();
                    this.putUnsignedVarInt(ingredients.size());
                    for (Item ingredient : ingredients) {
                        this.putRecipeIngredient(ingredient);
                    }
                    this.putUnsignedVarInt(1L);
                    this.putSlot(shapeless.getResult(), true);
                    this.putUUID(shapeless.getId());
                    this.putString(recipe.getType() == RecipeType.CARTOGRAPHY ? CRAFTING_TAG_CARTOGRAPHY_TABLE : CRAFTING_TAG_CRAFTING_TABLE);
                    this.putVarInt(shapeless.getPriority());
                    this.putUnsignedVarInt(recipeNetworkId++);
                    break;
                }
                case SHAPED: {
                    ShapedRecipe shaped = (ShapedRecipe)recipe;
                    this.putString(shaped.getRecipeId());
                    this.putVarInt(shaped.getWidth());
                    this.putVarInt(shaped.getHeight());
                    for (int z = 0; z < shaped.getHeight(); ++z) {
                        for (int x = 0; x < shaped.getWidth(); ++x) {
                            this.putRecipeIngredient(shaped.getIngredient(x, z));
                        }
                    }
                    ArrayList<Item> outputs = new ArrayList<Item>();
                    outputs.add(shaped.getResult());
                    outputs.addAll(shaped.getExtraResults());
                    this.putUnsignedVarInt(outputs.size());
                    for (Item output : outputs) {
                        this.putSlot(output, true);
                    }
                    this.putUUID(shaped.getId());
                    this.putString(CRAFTING_TAG_CRAFTING_TABLE);
                    this.putVarInt(shaped.getPriority());
                    this.putUnsignedVarInt(recipeNetworkId++);
                    break;
                }
                case FURNACE: 
                case FURNACE_DATA: 
                case SMOKER: 
                case SMOKER_DATA: 
                case BLAST_FURNACE: 
                case BLAST_FURNACE_DATA: 
                case CAMPFIRE: 
                case CAMPFIRE_DATA: {
                    SmeltingRecipe smelting = (SmeltingRecipe)recipe;
                    Item input = smelting.getInput();
                    this.putVarInt(input.getId());
                    if (recipe.getType().name().endsWith("_DATA")) {
                        this.putVarInt(input.getDamage());
                    }
                    this.putSlot(smelting.getResult(), true);
                    switch (recipe.getType()) {
                        case FURNACE: 
                        case FURNACE_DATA: {
                            this.putString(CRAFTING_TAG_FURNACE);
                            break block0;
                        }
                        case SMOKER: 
                        case SMOKER_DATA: {
                            this.putString(CRAFTING_TAG_SMOKER);
                            break block0;
                        }
                        case BLAST_FURNACE: 
                        case BLAST_FURNACE_DATA: {
                            this.putString(CRAFTING_TAG_BLAST_FURNACE);
                            break block0;
                        }
                        case CAMPFIRE: 
                        case CAMPFIRE_DATA: {
                            this.putString(CRAFTING_TAG_CAMPFIRE);
                        }
                    }
                    break;
                }
                case MULTI: {
                    this.putUUID(((MultiRecipe)recipe).getId());
                    this.putUnsignedVarInt(recipeNetworkId++);
                }
            }
        }
        this.putUnsignedVarInt(this.brewingEntries.size());
        for (BrewingRecipe brewingRecipe : this.brewingEntries) {
            this.putVarInt(brewingRecipe.getInput().getNetworkId());
            this.putVarInt(brewingRecipe.getInput().getDamage());
            this.putVarInt(brewingRecipe.getIngredient().getNetworkId());
            this.putVarInt(brewingRecipe.getIngredient().getDamage());
            this.putVarInt(brewingRecipe.getResult().getNetworkId());
            this.putVarInt(brewingRecipe.getResult().getDamage());
        }
        this.putUnsignedVarInt(this.containerEntries.size());
        for (ContainerRecipe containerRecipe : this.containerEntries) {
            this.putVarInt(containerRecipe.getInput().getNetworkId());
            this.putVarInt(containerRecipe.getIngredient().getNetworkId());
            this.putVarInt(containerRecipe.getResult().getNetworkId());
        }
        this.putUnsignedVarInt(0L);
        this.putBoolean(this.cleanRecipes);
    }

    @Override
    public byte pid() {
        return 52;
    }

    @Generated
    public String toString() {
        return "CraftingDataPacket(entries=" + this.entries + ", brewingEntries=" + this.brewingEntries + ", containerEntries=" + this.containerEntries + ", cleanRecipes=" + this.cleanRecipes + ")";
    }
}

