/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.math.Vector3f;
import cn.nukkit.network.protocol.DataPacket;
import lombok.Generated;

public class MoveEntityAbsolutePacket
extends DataPacket {
    public static final byte NETWORK_ID = 18;
    public long eid;
    public double x;
    public double y;
    public double z;
    public double yaw;
    public double headYaw;
    public double pitch;
    public boolean onGround;
    public boolean teleport;

    @Override
    public byte pid() {
        return 18;
    }

    @Override
    public void decode() {
        this.eid = this.getEntityRuntimeId();
        int flags = this.getByte();
        this.teleport = (flags & 1) != 0;
        this.onGround = (flags & 2) != 0;
        Vector3f v = this.getVector3f();
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.pitch = (double)this.getByte() * 1.40625;
        this.headYaw = (double)this.getByte() * 1.40625;
        this.yaw = (double)this.getByte() * 1.40625;
    }

    @Override
    public void encode() {
        this.reset();
        this.putEntityRuntimeId(this.eid);
        byte flags = 0;
        if (this.onGround) {
            flags = (byte)(flags | 1);
        }
        if (this.teleport) {
            flags = (byte)(flags | 2);
        }
        this.putByte(flags);
        this.putVector3f((float)this.x, (float)this.y, (float)this.z);
        this.putByte((byte)(this.pitch / 1.40625));
        this.putByte((byte)(this.headYaw / 1.40625));
        this.putByte((byte)(this.yaw / 1.40625));
    }

    @Generated
    public String toString() {
        return "MoveEntityAbsolutePacket(eid=" + this.eid + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", yaw=" + this.yaw + ", headYaw=" + this.headYaw + ", pitch=" + this.pitch + ", onGround=" + this.onGround + ", teleport=" + this.teleport + ")";
    }
}

