/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.network.protocol.AbstractResourcePackDataPacket;
import cn.nukkit.network.protocol.DataPacket;
import java.util.UUID;
import lombok.Generated;
import org.powernukkit.version.Version;

@PowerNukkitDifference(extendsOnlyInPowerNukkit=AbstractResourcePackDataPacket.class, insteadOf=DataPacket.class, since="1.5.2.0-PN")
public class ResourcePackDataInfoPacket
extends AbstractResourcePackDataPacket {
    public static final byte NETWORK_ID = 82;
    public static final int TYPE_INVALID = 0;
    public static final int TYPE_ADDON = 1;
    public static final int TYPE_CACHED = 2;
    public static final int TYPE_COPY_PROTECTED = 3;
    public static final int TYPE_BEHAVIOR = 4;
    public static final int TYPE_PERSONA_PIECE = 5;
    public static final int TYPE_RESOURCE = 6;
    public static final int TYPE_SKINS = 7;
    public static final int TYPE_WORLD_TEMPLATE = 8;
    public static final int TYPE_COUNT = 9;
    public UUID packId;
    private Version packVersion;
    public int maxChunkSize;
    public int chunkCount;
    public long compressedPackSize;
    public byte[] sha256;
    public boolean premium;
    public int type = 6;

    @Override
    public void decode() {
        this.decodePackInfo();
        this.maxChunkSize = this.getLInt();
        this.chunkCount = this.getLInt();
        this.compressedPackSize = this.getLLong();
        this.sha256 = this.getByteArray();
        this.premium = this.getBoolean();
        this.type = this.getByte();
    }

    @Override
    public void encode() {
        this.reset();
        this.encodePackInfo();
        this.putLInt(this.maxChunkSize);
        this.putLInt(this.chunkCount);
        this.putLLong(this.compressedPackSize);
        this.putByteArray(this.sha256);
        this.putBoolean(this.premium);
        this.putByte((byte)this.type);
    }

    @Override
    public byte pid() {
        return 82;
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public Version getPackVersion() {
        return this.packVersion;
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setPackVersion(Version packVersion) {
        this.packVersion = packVersion;
    }

    @Override
    @Since(value="1.5.2.0-PN")
    @PowerNukkitOnly
    public UUID getPackId() {
        return this.packId;
    }

    @Override
    @Since(value="1.5.2.0-PN")
    @PowerNukkitOnly
    public void setPackId(UUID packId) {
        this.packId = packId;
    }

    @Generated
    public String toString() {
        return "ResourcePackDataInfoPacket(packId=" + this.getPackId() + ", packVersion=" + this.getPackVersion() + ", maxChunkSize=" + this.maxChunkSize + ", chunkCount=" + this.chunkCount + ", compressedPackSize=" + this.compressedPackSize + ", premium=" + this.premium + ", type=" + this.type + ")";
    }
}

