/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.resourcepacks.ResourcePack;
import java.util.Arrays;
import lombok.Generated;

public class ResourcePacksInfoPacket
extends DataPacket {
    public static final byte NETWORK_ID = 6;
    public boolean mustAccept;
    public boolean scripting;
    public ResourcePack[] behaviourPackEntries = ResourcePack.EMPTY_ARRAY;
    public ResourcePack[] resourcePackEntries = ResourcePack.EMPTY_ARRAY;
    private boolean forcingServerPacksEnabled;

    @Override
    public void decode() {
    }

    @Override
    public void encode() {
        this.reset();
        this.putBoolean(this.mustAccept);
        this.putBoolean(this.scripting);
        this.putBoolean(this.forcingServerPacksEnabled);
        this.encodePacks(this.behaviourPackEntries);
        this.encodePacks(this.resourcePackEntries);
    }

    private void encodePacks(ResourcePack[] packs) {
        this.putLShort(packs.length);
        for (ResourcePack entry : packs) {
            this.putString(entry.getPackId().toString());
            this.putString(entry.getPackVersion());
            this.putLLong(entry.getPackSize());
            this.putString("");
            this.putString("");
            this.putString(entry.getPackId().toString());
            this.putBoolean(false);
            this.putBoolean(false);
        }
    }

    @Override
    public byte pid() {
        return 6;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public boolean isForcedToAccept() {
        return this.mustAccept;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setForcedToAccept(boolean mustAccept) {
        this.mustAccept = mustAccept;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public boolean isScriptingEnabled() {
        return this.scripting;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setScriptingEnabled(boolean scripting) {
        this.scripting = scripting;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public ResourcePack[] getBehaviourPackEntries() {
        return this.behaviourPackEntries;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setBehaviourPackEntries(ResourcePack[] behaviourPackEntries) {
        this.behaviourPackEntries = behaviourPackEntries;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public ResourcePack[] getResourcePackEntries() {
        return this.resourcePackEntries;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setResourcePackEntries(ResourcePack[] resourcePackEntries) {
        this.resourcePackEntries = resourcePackEntries;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public boolean isForcingServerPacksEnabled() {
        return this.forcingServerPacksEnabled;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setForcingServerPacksEnabled(boolean forcingServerPacksEnabled) {
        this.forcingServerPacksEnabled = forcingServerPacksEnabled;
    }

    @Generated
    public String toString() {
        return "ResourcePacksInfoPacket(mustAccept=" + this.mustAccept + ", scripting=" + this.scripting + ", behaviourPackEntries=" + Arrays.deepToString(this.getBehaviourPackEntries()) + ", resourcePackEntries=" + Arrays.deepToString(this.getResourcePackEntries()) + ", forcingServerPacksEnabled=" + this.isForcingServerPacksEnabled() + ")";
    }
}

