/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.permission;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BanEntry {
    @Generated
    private static final Logger log = LogManager.getLogger(BanEntry.class);
    public static final String format = "yyyy-MM-dd HH:mm:ss Z";
    private final String name;
    private Date creationDate = null;
    private String source = "(Unknown)";
    private Date expirationDate = null;
    private String reason = "Banned by an operator.";

    public BanEntry(String name) {
        this.name = name.toLowerCase();
        this.creationDate = new Date();
    }

    public String getName() {
        return this.name;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public boolean hasExpired() {
        Date now = new Date();
        return this.expirationDate != null && this.expirationDate.before(now);
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public LinkedHashMap<String, String> getMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("name", this.getName());
        map.put("creationDate", new SimpleDateFormat(format).format(this.getCreationDate()));
        map.put("source", this.getSource());
        map.put("expireDate", this.getExpirationDate() != null ? new SimpleDateFormat(format).format(this.getExpirationDate()) : "Forever");
        map.put("reason", this.getReason());
        return map;
    }

    public static BanEntry fromMap(Map<String, String> map) {
        BanEntry banEntry = new BanEntry(map.get("name"));
        try {
            banEntry.setCreationDate(new SimpleDateFormat(format).parse(map.get("creationDate")));
            banEntry.setExpirationDate(!map.get("expireDate").equals("Forever") ? new SimpleDateFormat(format).parse(map.get("expireDate")) : null);
        }
        catch (ParseException e) {
            log.error("An exception happed while loading the ban list.", (Throwable)e);
        }
        banEntry.setSource(map.get("source"));
        banEntry.setReason(map.get("reason"));
        return banEntry;
    }

    public String getString() {
        return new Gson().toJson(this.getMap());
    }

    public static BanEntry fromString(String str) {
        Map map = (Map)new Gson().fromJson(str, new TypeToken<TreeMap<String, String>>(){}.getType());
        BanEntry banEntry = new BanEntry((String)map.get("name"));
        try {
            banEntry.setCreationDate(new SimpleDateFormat(format).parse((String)map.get("creationDate")));
            banEntry.setExpirationDate(!((String)map.get("expireDate")).equals("Forever") ? new SimpleDateFormat(format).parse((String)map.get("expireDate")) : null);
        }
        catch (ParseException e) {
            log.error("An exception happened while loading a ban entry from the string {}", (Object)str, (Object)e);
        }
        banEntry.setSource((String)map.get("source"));
        banEntry.setReason((String)map.get("reason"));
        return banEntry;
    }
}

