/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.resourcepacks;

import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.resourcepacks.ResourcePack;
import cn.nukkit.resourcepacks.ZippedResourcePack;
import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourcePackManager {
    @Generated
    private static final Logger log = LogManager.getLogger(ResourcePackManager.class);
    private int maxChunkSize = 102400;
    private final Map<UUID, ResourcePack> resourcePacksById = new HashMap<UUID, ResourcePack>();
    private ResourcePack[] resourcePacks;

    public ResourcePackManager(File path) {
        if (!path.exists()) {
            path.mkdirs();
        } else if (!path.isDirectory()) {
            throw new IllegalArgumentException(Server.getInstance().getLanguage().translateString("nukkit.resources.invalid-path", path.getName()));
        }
        ArrayList<ResourcePack> loadedResourcePacks = new ArrayList<ResourcePack>();
        for (File pack : path.listFiles()) {
            try {
                ResourcePack resourcePack = null;
                if (!pack.isDirectory()) {
                    switch (Files.getFileExtension((String)pack.getName())) {
                        case "zip": 
                        case "mcpack": {
                            resourcePack = new ZippedResourcePack(pack);
                            break;
                        }
                        default: {
                            log.warn(Server.getInstance().getLanguage().translateString("nukkit.resources.unknown-format", pack.getName()));
                        }
                    }
                }
                if (resourcePack == null) continue;
                loadedResourcePacks.add(resourcePack);
                this.resourcePacksById.put(resourcePack.getPackId(), resourcePack);
            }
            catch (IllegalArgumentException e) {
                log.warn(Server.getInstance().getLanguage().translateString("nukkit.resources.fail", pack.getName(), e.getMessage()), (Throwable)e);
            }
        }
        this.resourcePacks = loadedResourcePacks.toArray(ResourcePack.EMPTY_ARRAY);
        log.info(Server.getInstance().getLanguage().translateString("nukkit.resources.success", String.valueOf(this.resourcePacks.length)));
    }

    public ResourcePack[] getResourceStack() {
        return this.resourcePacks;
    }

    public ResourcePack getPackById(UUID id) {
        return this.resourcePacksById.get(id);
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public void setMaxChunkSize(int size) {
        this.maxChunkSize = size;
    }
}

