/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.scheduler;

import cn.nukkit.Server;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.scheduler.TaskHandler;

public abstract class NukkitRunnable
implements Runnable {
    private TaskHandler taskHandler;

    public synchronized void cancel() throws IllegalStateException {
        this.taskHandler.cancel();
    }

    public synchronized Runnable runTask(Plugin plugin) throws IllegalArgumentException, IllegalStateException {
        this.checkState();
        this.taskHandler = Server.getInstance().getScheduler().scheduleTask(plugin, this);
        return this.taskHandler.getTask();
    }

    public synchronized Runnable runTaskAsynchronously(Plugin plugin) throws IllegalArgumentException, IllegalStateException {
        this.checkState();
        this.taskHandler = Server.getInstance().getScheduler().scheduleTask(plugin, this, true);
        return this.taskHandler.getTask();
    }

    public synchronized Runnable runTaskLater(Plugin plugin, int delay) throws IllegalArgumentException, IllegalStateException {
        this.checkState();
        this.taskHandler = Server.getInstance().getScheduler().scheduleDelayedTask(plugin, this, delay);
        return this.taskHandler.getTask();
    }

    public synchronized Runnable runTaskLaterAsynchronously(Plugin plugin, int delay) throws IllegalArgumentException, IllegalStateException {
        this.checkState();
        this.taskHandler = Server.getInstance().getScheduler().scheduleDelayedTask(plugin, this, delay, true);
        return this.taskHandler.getTask();
    }

    public synchronized Runnable runTaskTimer(Plugin plugin, int delay, int period) throws IllegalArgumentException, IllegalStateException {
        this.checkState();
        this.taskHandler = Server.getInstance().getScheduler().scheduleDelayedRepeatingTask(plugin, this, delay, period);
        return this.taskHandler.getTask();
    }

    public synchronized Runnable runTaskTimerAsynchronously(Plugin plugin, int delay, int period) throws IllegalArgumentException, IllegalStateException {
        this.checkState();
        this.taskHandler = Server.getInstance().getScheduler().scheduleDelayedRepeatingTask(plugin, this, delay, period, true);
        return this.taskHandler.getTask();
    }

    public synchronized int getTaskId() throws IllegalStateException {
        if (this.taskHandler == null) {
            throw new IllegalStateException("Not scheduled yet");
        }
        int id = this.taskHandler.getTaskId();
        return id;
    }

    private void checkState() {
        if (this.taskHandler != null) {
            throw new IllegalStateException("Already scheduled as " + this.taskHandler.getTaskId());
        }
    }
}

