/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.Server;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Watchdog
extends Thread {
    @Generated
    private static final Logger log = LogManager.getLogger(Watchdog.class);
    private final Server server;
    private final long time;
    public volatile boolean running;
    private boolean responding = true;
    private Thread forcedFinalizer;
    private boolean warnedAboutFinalizer;

    public Watchdog(Server server, long time) {
        this.server = server;
        this.time = time;
        this.running = true;
        this.setName("Watchdog");
        this.setDaemon(true);
    }

    public void kill() {
        this.running = false;
        this.interrupt();
    }

    private void checkFinalizer() {
        if (this.forcedFinalizer != null && this.forcedFinalizer.isAlive()) {
            StringBuilder sb = new StringBuilder("--------- The finalizer thread didn't complete in time! ---------").append('\n').append("This detection means that the finalizer thread may be stuck and").append('\n').append("RAM memory might be leaking!").append('\n').append(" - https://github.com/PowerNukkit/PowerNukkit/issues/new").append('\n').append("---------------- ForcedFinalizer ----------------").append('\n');
            Watchdog.dumpThread(ManagementFactory.getThreadMXBean().getThreadInfo(this.forcedFinalizer.getId(), Integer.MAX_VALUE), sb);
            sb.append("-------------------------------------------------");
            log.fatal(sb.toString());
            this.warnedAboutFinalizer = true;
        } else {
            if (this.warnedAboutFinalizer) {
                log.warn("The ForcedFinalizer has finished");
                this.warnedAboutFinalizer = false;
            }
            this.forcedFinalizer = new Thread(() -> {
                log.trace("Forcing finalization");
                System.runFinalization();
                log.trace("Forced finalization completed");
            });
            this.forcedFinalizer.setName("ForcedFinalizer");
            this.forcedFinalizer.setDaemon(true);
            this.forcedFinalizer.start();
        }
    }

    @Override
    public void run() {
        while (this.running) {
            this.checkFinalizer();
            long current = this.server.getNextTick();
            if (current != 0L) {
                long diff = System.currentTimeMillis() - current;
                if (!this.responding && diff > this.time * 2L) {
                    System.exit(1);
                }
                if (diff <= this.time) {
                    this.responding = true;
                } else if (this.responding) {
                    StringBuilder builder = new StringBuilder("--------- Server stopped responding --------- (" + Math.round((double)diff / 1000.0) + "s)").append('\n').append("Please report this to PowerNukkit:").append('\n').append(" - https://github.com/PowerNukkit/PowerNukkit/issues/new").append('\n').append("---------------- Main thread ----------------").append('\n');
                    Watchdog.dumpThread(ManagementFactory.getThreadMXBean().getThreadInfo(this.server.getPrimaryThread().getId(), Integer.MAX_VALUE), builder);
                    builder.append("---------------- All threads ----------------").append('\n');
                    ThreadInfo[] threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
                    for (int i = 0; i < threads.length; ++i) {
                        if (i != 0) {
                            builder.append("------------------------------").append('\n');
                        }
                        Watchdog.dumpThread(threads[i], builder);
                    }
                    builder.append("---------------------------------------------").append('\n');
                    log.fatal(builder.toString());
                    this.responding = false;
                    this.server.forceShutdown();
                }
            }
            try {
                Watchdog.sleep(Math.max(this.time / 4L, 1000L));
            }
            catch (InterruptedException interruption) {
                log.fatal("The Watchdog Thread has been interrupted and is no longer monitoring the server state", (Throwable)interruption);
                this.running = false;
                return;
            }
        }
        log.warn("Watchdog was stopped");
    }

    private static void dumpThread(ThreadInfo thread, StringBuilder builder) {
        if (thread == null) {
            builder.append("Attempted to dump a null thread!").append('\n');
            return;
        }
        builder.append("Current Thread: " + thread.getThreadName()).append('\n');
        builder.append("\tPID: " + thread.getThreadId() + " | Suspended: " + thread.isSuspended() + " | Native: " + thread.isInNative() + " | State: " + (Object)((Object)thread.getThreadState())).append('\n');
        if (thread.getLockedMonitors().length != 0) {
            builder.append("\tThread is waiting on monitor(s):").append('\n');
            for (MonitorInfo monitor : thread.getLockedMonitors()) {
                builder.append("\t\tLocked on:" + monitor.getLockedStackFrame()).append('\n');
            }
        }
        builder.append("\tStack:").append('\n');
        for (StackTraceElement stack : thread.getStackTrace()) {
            builder.append("\t\t" + stack).append('\n');
        }
    }
}

