/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils.functional;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.math.IntIncrementSupplier;
import cn.nukkit.math.NukkitMath;
import com.google.common.base.Preconditions;
import java.util.stream.IntStream;

@FunctionalInterface
@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public interface BlockPositionConsumer {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void accept(int var1, int var2, int var3);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void validate(int fromX, int fromY, int fromZ, int toX, int toY, int toZ, int xInc, int yInc, int zInc) {
        if (fromX <= toX) {
            Preconditions.checkArgument((xInc > 0 ? 1 : 0) != 0, (Object)"Invalid xInc");
        } else {
            Preconditions.checkArgument((xInc < 0 ? 1 : 0) != 0, (Object)"Invalid xInc");
        }
        if (fromY <= toY) {
            Preconditions.checkArgument((yInc > 0 ? 1 : 0) != 0, (Object)"Invalid yInc");
        } else {
            Preconditions.checkArgument((yInc < 0 ? 1 : 0) != 0, (Object)"Invalid yInc");
        }
        if (fromZ <= toZ) {
            Preconditions.checkArgument((zInc > 0 ? 1 : 0) != 0, (Object)"Invalid zInc");
        } else {
            Preconditions.checkArgument((zInc < 0 ? 1 : 0) != 0, (Object)"Invalid zInc");
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void xzy(int fromX, int fromY, int fromZ, int toX, int toY, int toZ, int xInc, int yInc, int zInc, BlockPositionConsumer iterator) {
        BlockPositionConsumer.validate(fromX, fromY, fromZ, toX, toY, toZ, xInc, yInc, zInc);
        IntStream xStream = new IntIncrementSupplier(fromX, xInc).stream().limit(NukkitMath.floorFloat((float)(toX - fromX) / (float)xInc));
        IntStream yStream = new IntIncrementSupplier(fromY, yInc).stream().limit(NukkitMath.floorFloat((float)(toY - fromY) / (float)yInc));
        IntStream zStream = new IntIncrementSupplier(fromZ, zInc).stream().limit(NukkitMath.floorFloat((float)(toZ - fromZ) / (float)zInc));
        xStream.forEachOrdered(x -> zStream.forEachOrdered(z -> yStream.forEachOrdered(y -> iterator.accept(x, y, z))));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void xzy(int fromX, int fromY, int fromZ, int toX, int toY, int toZ, BlockPositionConsumer iterator) {
        BlockPositionConsumer.xzy(fromX, fromY, fromZ, toX, toY, toZ, fromX <= toX ? 1 : -1, fromY <= toY ? 1 : -1, fromZ <= toZ ? 1 : -1, iterator);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void xzy(int toX, int toY, int toZ, BlockPositionConsumer iterator) {
        BlockPositionConsumer.xzy(0, 0, 0, toX, toY, toZ, iterator);
    }
}

