/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.entity.Attribute;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.EntityRegainHealthEvent;
import cn.nukkit.event.player.PlayerFoodLevelChangeEvent;
import cn.nukkit.item.food.Food;

public class PlayerFood {
    private int foodLevel = 20;
    private final int maxFoodLevel;
    private float foodSaturationLevel = 20.0f;
    private int foodTickTimer = 0;
    private double foodExpLevel = 0.0;
    private final Player player;

    public PlayerFood(Player player, int foodLevel, float foodSaturationLevel) {
        this.player = player;
        this.foodLevel = foodLevel;
        this.maxFoodLevel = 20;
        this.foodSaturationLevel = foodSaturationLevel;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getLevel() {
        return this.foodLevel;
    }

    public int getMaxLevel() {
        return this.maxFoodLevel;
    }

    public void setLevel(int foodLevel) {
        this.setLevel(foodLevel, -1.0f);
    }

    public void setLevel(int foodLevel, float saturationLevel) {
        if (foodLevel > 20) {
            foodLevel = 20;
        }
        if (foodLevel < 0) {
            foodLevel = 0;
        }
        if (foodLevel <= 6 && this.getLevel() > 6 && this.getPlayer().isSprinting()) {
            this.getPlayer().setSprinting(false);
        }
        PlayerFoodLevelChangeEvent ev = new PlayerFoodLevelChangeEvent(this.getPlayer(), foodLevel, saturationLevel);
        this.getPlayer().getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            this.sendFoodLevel(this.getLevel());
            return;
        }
        int foodLevel0 = ev.getFoodLevel();
        float fsl = ev.getFoodSaturationLevel();
        this.foodLevel = foodLevel;
        if (fsl != -1.0f) {
            if (fsl > (float)foodLevel) {
                fsl = foodLevel;
            }
            this.foodSaturationLevel = fsl;
        }
        this.foodLevel = foodLevel0;
        this.sendFoodLevel();
    }

    public float getFoodSaturationLevel() {
        return this.foodSaturationLevel;
    }

    public void setFoodSaturationLevel(float fsl) {
        if (fsl > (float)this.getLevel()) {
            fsl = this.getLevel();
        }
        if (fsl < 0.0f) {
            fsl = 0.0f;
        }
        PlayerFoodLevelChangeEvent ev = new PlayerFoodLevelChangeEvent(this.getPlayer(), this.getLevel(), fsl);
        this.getPlayer().getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return;
        }
        this.foodSaturationLevel = fsl = ev.getFoodSaturationLevel();
    }

    public void useHunger() {
        this.useHunger(1);
    }

    public void useHunger(int amount) {
        float sfl = this.getFoodSaturationLevel();
        int foodLevel = this.getLevel();
        if (sfl > 0.0f) {
            float newSfl = sfl - (float)amount;
            if (newSfl < 0.0f) {
                newSfl = 0.0f;
            }
            this.setFoodSaturationLevel(newSfl);
        } else {
            this.setLevel(foodLevel - amount);
        }
    }

    public void addFoodLevel(Food food) {
        this.addFoodLevel(food.getRestoreFood(), food.getRestoreSaturation());
    }

    public void addFoodLevel(int foodLevel, float fsl) {
        this.setLevel(this.getLevel() + foodLevel, this.getFoodSaturationLevel() + fsl);
    }

    public void sendFoodLevel() {
        this.sendFoodLevel(this.getLevel());
    }

    public void reset() {
        this.foodLevel = 20;
        this.foodSaturationLevel = 20.0f;
        this.foodExpLevel = 0.0;
        this.foodTickTimer = 0;
        this.sendFoodLevel();
    }

    public void sendFoodLevel(int foodLevel) {
        if (this.getPlayer().spawned) {
            this.getPlayer().setAttribute(Attribute.getAttribute(7).setValue(foodLevel));
        }
    }

    public void update(int tickDiff) {
        if (!this.getPlayer().isFoodEnabled()) {
            return;
        }
        if (this.getPlayer().isAlive()) {
            int diff = Server.getInstance().getDifficulty();
            if (this.getLevel() > 17) {
                this.foodTickTimer += tickDiff;
                if (this.foodTickTimer >= 80) {
                    if (this.getPlayer().getHealth() < (float)this.getPlayer().getMaxHealth()) {
                        EntityRegainHealthEvent ev = new EntityRegainHealthEvent(this.getPlayer(), 1.0f, 1);
                        this.getPlayer().heal(ev);
                        this.updateFoodExpLevel(6.0);
                    }
                    this.foodTickTimer = 0;
                }
            } else if (this.getLevel() == 0) {
                this.foodTickTimer += tickDiff;
                if (this.foodTickTimer >= 80) {
                    EntityDamageEvent ev = new EntityDamageEvent((Entity)this.getPlayer(), EntityDamageEvent.DamageCause.HUNGER, 1.0f);
                    float now = this.getPlayer().getHealth();
                    if (diff == 1) {
                        if (now > 10.0f) {
                            this.getPlayer().attack(ev);
                        }
                    } else if (diff == 2) {
                        if (now > 1.0f) {
                            this.getPlayer().attack(ev);
                        }
                    } else {
                        this.getPlayer().attack(ev);
                    }
                    this.foodTickTimer = 0;
                }
            }
            if (this.getPlayer().hasEffect(17)) {
                this.updateFoodExpLevel(0.025);
            }
        }
    }

    public void updateFoodExpLevel(double use) {
        if (!this.getPlayer().isFoodEnabled()) {
            return;
        }
        if (Server.getInstance().getDifficulty() == 0) {
            return;
        }
        if (this.getPlayer().hasEffect(23)) {
            return;
        }
        this.foodExpLevel += use;
        if (this.foodExpLevel > 4.0) {
            this.useHunger(1);
            this.foodExpLevel = 0.0;
        }
    }

    @Deprecated
    public void setFoodLevel(int foodLevel) {
        this.setLevel(foodLevel);
    }

    @Deprecated
    public void setFoodLevel(int foodLevel, float saturationLevel) {
        this.setLevel(foodLevel, saturationLevel);
    }
}

