/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockSignPost;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityBanner;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.item.Item;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.CompassRoseDirection;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.IntTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.DyeColor;
import cn.nukkit.utils.Faceable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@PowerNukkitDifference(since="1.4.0.0-PN", info="Implements BlockEntityHolder only in PowerNukkit")
public class BlockBanner
extends BlockTransparentMeta
implements Faceable,
BlockEntityHolder<BlockEntityBanner> {
    @Generated
    private static final Logger log = LogManager.getLogger(BlockBanner.class);

    public BlockBanner() {
        this(0);
    }

    public BlockBanner(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 176;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return BlockSignPost.PROPERTIES;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "Banner";
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityBanner> getBlockEntityClass() {
        return BlockEntityBanner.class;
    }

    @Override
    public double getHardness() {
        return 1.0;
    }

    @Override
    public double getResistance() {
        return 5.0;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public String getName() {
        return "Banner";
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        return null;
    }

    @Override
    public boolean canPassThrough() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        Tag patterns;
        if (face == BlockFace.DOWN) {
            return false;
        }
        Block layer0 = this.level.getBlock((Vector3)this, 0);
        Block layer1 = this.level.getBlock((Vector3)this, 1);
        if (face == BlockFace.UP) {
            CompassRoseDirection direction = BlockSignPost.GROUND_SIGN_DIRECTION.getValueForMeta((int)Math.floor(((player != null ? player.yaw : 0.0) + 180.0) * 16.0 / 360.0 + 0.5) & 0xF);
            this.setDirection(direction);
            if (!this.getLevel().setBlock((Vector3)block, this, true)) {
                return false;
            }
        } else {
            BlockBanner wall = (BlockBanner)Block.get(177);
            wall.setBlockFace(face);
            if (!this.getLevel().setBlock((Vector3)block, wall, true)) {
                return false;
            }
        }
        CompoundTag nbt = BlockEntity.getDefaultCompound(this, "Banner").putInt("Base", item.getDamage() & 0xF);
        Tag type = item.getNamedTagEntry("Type");
        if (type instanceof IntTag) {
            nbt.put("Type", type);
        }
        if ((patterns = item.getNamedTagEntry("Patterns")) instanceof ListTag) {
            nbt.put("Patterns", patterns);
        }
        try {
            this.createBlockEntity(nbt, new Object[0]);
            return true;
        }
        catch (Exception e) {
            log.error("Failed to create the block entity {} at {}", (Object)this.getBlockEntityType(), (Object)this.getLocation(), (Object)e);
            this.level.setBlock((Vector3)layer0, 0, layer0, true);
            this.level.setBlock((Vector3)layer0, 1, layer1, true);
            return false;
        }
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && this.down().getId() == 0) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        return 0;
    }

    @Override
    public Item toItem() {
        BlockEntityBanner banner = (BlockEntityBanner)this.getBlockEntity();
        Item item = Item.get(446);
        if (banner != null) {
            ListTag<CompoundTag> patterns;
            item.setDamage(banner.getBaseColor() & 0xF);
            int type = banner.namedTag.getInt("Type");
            if (type > 0) {
                item.setNamedTag((item.hasCompoundTag() ? item.getNamedTag() : new CompoundTag()).putInt("Type", type));
            }
            if ((patterns = banner.namedTag.getList("Patterns", CompoundTag.class)).size() > 0) {
                item.setNamedTag((item.hasCompoundTag() ? item.getNamedTag() : new CompoundTag()).putList(patterns));
            }
        }
        return item;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public CompassRoseDirection getDirection() {
        return this.getPropertyValue(BlockSignPost.GROUND_SIGN_DIRECTION);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setDirection(CompassRoseDirection direction) {
        this.setPropertyValue(BlockSignPost.GROUND_SIGN_DIRECTION, direction);
    }

    @Override
    @PowerNukkitDifference(info="Was returning the wrong face, it now return the closest face, or the left face if even", since="1.4.0.0-PN")
    public BlockFace getBlockFace() {
        return this.getDirection().getClosestBlockFace();
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public void setBlockFace(BlockFace face) {
        this.setDirection(face.getCompassRoseDirection());
    }

    @Override
    @PowerNukkitOnly
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public BlockColor getColor() {
        return this.getDyeColor().getColor();
    }

    public DyeColor getDyeColor() {
        BlockEntityBanner blockEntity;
        if (this.level != null && (blockEntity = (BlockEntityBanner)this.getBlockEntity()) != null) {
            return blockEntity.getDyeColor();
        }
        return DyeColor.WHITE;
    }
}

