/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.api.UsedByReflection;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockLever;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.RedstoneComponent;
import javax.annotation.Nonnull;

@PowerNukkitDifference(info="Implements RedstoneComponent and uses methods from it.", since="1.4.0.0-PN")
public abstract class BlockButton
extends BlockFlowable
implements RedstoneComponent,
Faceable {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected static final BooleanBlockProperty BUTTON_PRESSED = new BooleanBlockProperty("button_pressed_bit", false);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.FACING_DIRECTION, BUTTON_PRESSED);

    @UsedByReflection
    public BlockButton() {
        this(0);
    }

    @UsedByReflection
    public BlockButton(int meta) {
        super(meta);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean canBeFlowedInto() {
        return false;
    }

    @Override
    @PowerNukkitDifference.DifferenceList(value={@PowerNukkitDifference(info="Allow to be placed on top of the walls", since="1.3.0.0-PN"), @PowerNukkitDifference(info="Now, can be placed on solid blocks", since="1.4.0.0-PN")})
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (!BlockLever.isSupportValid(target, face)) {
            return false;
        }
        this.setBlockFace(face);
        this.level.setBlock((Vector3)block, this, true, true);
        return true;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (this.isActivated()) {
            return false;
        }
        this.level.scheduleUpdate(this, 30);
        this.setActivated(true);
        this.level.setBlock((Vector3)this, this, true, false);
        this.level.addLevelSoundEvent(this.add(0.5, 0.5, 0.5), 73, GlobalBlockPalette.getOrCreateRuntimeId(this.getId(), this.getDamage()));
        if (this.level.getServer().isRedstoneEnabled()) {
            this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 0, 15));
            this.updateAroundRedstone(new BlockFace[0]);
            RedstoneComponent.updateAroundRedstone((Position)this.getSide(this.getFacing().getOpposite()), this.getFacing());
        }
        return true;
    }

    @Override
    @PowerNukkitDifference(info="Now, can be placed on solid blocks", since="1.4.0.0-PN")
    public int onUpdate(int type) {
        if (type == 1) {
            BlockFace thisFace = this.getFacing();
            BlockFace touchingFace = thisFace.getOpposite();
            Block side = this.getSide(touchingFace);
            if (!BlockLever.isSupportValid(side, thisFace)) {
                this.level.useBreakOn(this);
                return 1;
            }
        } else if (type == 3) {
            if (this.isActivated()) {
                this.setActivated(false);
                this.level.setBlock((Vector3)this, this, true, false);
                this.level.addLevelSoundEvent(this.add(0.5, 0.5, 0.5), 74, GlobalBlockPalette.getOrCreateRuntimeId(this.getId(), this.getDamage()));
                if (this.level.getServer().isRedstoneEnabled()) {
                    this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 15, 0));
                    this.updateAroundRedstone(new BlockFace[0]);
                    RedstoneComponent.updateAroundRedstone((Position)this.getSide(this.getFacing().getOpposite()), this.getFacing());
                }
            }
            return 3;
        }
        return 0;
    }

    public boolean isActivated() {
        return this.getBooleanValue(BUTTON_PRESSED);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setActivated(boolean activated) {
        this.setBooleanValue(BUTTON_PRESSED, activated);
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    @Override
    public int getWeakPower(BlockFace side) {
        return this.isActivated() ? 15 : 0;
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return !this.isActivated() ? 0 : (this.getFacing() == side ? 15 : 0);
    }

    public BlockFace getFacing() {
        return this.getPropertyValue(CommonBlockProperties.FACING_DIRECTION);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setBlockFace(BlockFace face) {
        this.setPropertyValue(CommonBlockProperties.FACING_DIRECTION, face);
    }

    @Override
    public boolean onBreak(Item item) {
        if (this.isActivated()) {
            this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 15, 0));
        }
        return super.onBreak(item);
    }

    @Override
    public Item toItem() {
        return Item.get(this.getItemId());
    }

    @Override
    @PowerNukkitDifference(info="Was returning the wrong face", since="1.3.0.0-PN")
    public BlockFace getBlockFace() {
        return this.getFacing();
    }
}

