/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparent;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BlockChorusPlant
extends BlockTransparent {
    @Override
    public int getId() {
        return 240;
    }

    @Override
    public String getName() {
        return "Chorus Plant";
    }

    @Override
    public double getHardness() {
        return 0.4;
    }

    @Override
    public double getResistance() {
        return 0.4;
    }

    @Override
    public int getToolType() {
        return 0;
    }

    private boolean isPositionValid() {
        boolean horizontal = false;
        boolean horizontalSupported = false;
        Block down = this.down();
        for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
            Block sideSupport;
            Block side = this.getSide(face);
            if (side.getId() != 240) continue;
            if (!horizontal) {
                if (this.up().getId() != 0 && down.getId() != 0) {
                    return false;
                }
                horizontal = true;
            }
            if ((sideSupport = side.down()).getId() != 240 && sideSupport.getId() != 121) continue;
            horizontalSupported = true;
        }
        if (horizontal && horizontalSupported) {
            return true;
        }
        return down.getId() == 240 || down.getId() == 121;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (!this.isPositionValid()) {
                this.level.scheduleUpdate(this, 1);
                return type;
            }
        } else if (type == 3) {
            this.level.useBreakOn(this, null, null, true);
            return type;
        }
        return 0;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        if (!this.isPositionValid()) {
            return false;
        }
        return super.place(item, block, target, face, fx, fy, fz, player);
    }

    @Override
    public Item[] getDrops(Item item) {
        Item[] itemArray;
        if (ThreadLocalRandom.current().nextBoolean()) {
            Item[] itemArray2 = new Item[1];
            itemArray = itemArray2;
            itemArray2[0] = Item.get(432, 0, 1);
        } else {
            itemArray = Item.EMPTY_ARRAY;
        }
        return itemArray;
    }

    @Override
    @PowerNukkitOnly
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public boolean sticksToPiston() {
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.PURPLE_BLOCK_COLOR;
    }
}

