/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemStick;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.Random;
import javax.annotation.Nonnull;

public class BlockDeadBush
extends BlockFlowable {
    public BlockDeadBush() {
        this(0);
    }

    public BlockDeadBush(int meta) {
        super(0);
    }

    @Override
    public String getName() {
        return "Dead Bush";
    }

    @Override
    public int getId() {
        return 32;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return CommonBlockProperties.EMPTY_PROPERTIES;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean canBeReplaced() {
        return true;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed support logic")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (this.isSupportValid()) {
            this.getLevel().setBlock((Vector3)block, this, true, true);
            return true;
        }
        return false;
    }

    private boolean isSupportValid() {
        switch (this.down().getId()) {
            case 3: 
            case 12: 
            case 159: 
            case 172: 
            case 243: {
                return true;
            }
        }
        return false;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed support logic")
    public int onUpdate(int type) {
        if (type == 1 && !this.isSupportValid()) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        return 0;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isShears()) {
            return new Item[]{this.toItem()};
        }
        return new Item[]{new ItemStick((Integer)0, new Random().nextInt(3))};
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }
}

