/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFire;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityFallingBlock;
import cn.nukkit.event.block.BlockFallEvent;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;

public abstract class BlockFallable
extends BlockSolid {
    protected BlockFallable() {
    }

    @Override
    public int onUpdate(int type) {
        Block down;
        if (type == 1 && ((down = this.down()).getId() == 0 || down instanceof BlockFire || down instanceof BlockLiquid || down.getLevelBlockAtLayer(1) instanceof BlockLiquid)) {
            BlockFallEvent event = new BlockFallEvent(this);
            this.level.getServer().getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                return type;
            }
            this.level.setBlock((Vector3)this, Block.get(0), true, true);
            EntityFallingBlock fall = this.createFallingEntity(new CompoundTag());
            fall.spawnToAll();
        }
        return type;
    }

    @PowerNukkitOnly
    protected EntityFallingBlock createFallingEntity(CompoundTag customNbt) {
        CompoundTag nbt = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", this.x + 0.5)).add(new DoubleTag("", this.y)).add(new DoubleTag("", this.z + 0.5))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", 0.0f)).add(new FloatTag("", 0.0f))).putInt("TileID", this.getId()).putByte("Data", this.getDamage());
        for (Tag customTag : customNbt.getAllTags()) {
            nbt.put(customTag.getName(), customTag.copy());
        }
        EntityFallingBlock fall = (EntityFallingBlock)Entity.createEntity("FallingSand", (FullChunk)this.getLevel().getChunk((int)this.x >> 4, (int)this.z >> 4), nbt, new Object[0]);
        if (fall != null) {
            fall.spawnToAll();
        }
        return fall;
    }
}

