/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFence;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockLever;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockSlab;
import cn.nukkit.block.BlockStairs;
import cn.nukkit.block.BlockWallBase;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemTool;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;

@PowerNukkitOnly
public class BlockLantern
extends BlockFlowable {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BooleanBlockProperty HANGING = new BooleanBlockProperty("hanging", false);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(HANGING);

    @PowerNukkitOnly
    public BlockLantern() {
        this(0);
    }

    @PowerNukkitOnly
    public BlockLantern(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 463;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getName() {
        return "Lantern";
    }

    private boolean isBlockAboveValid() {
        Block support = this.up();
        switch (support.getId()) {
            case 101: 
            case 154: 
            case 541: {
                return true;
            }
        }
        if (support instanceof BlockWallBase || support instanceof BlockFence) {
            return true;
        }
        if (support instanceof BlockSlab && !((BlockSlab)support).isOnTop()) {
            return true;
        }
        if (support instanceof BlockStairs && !((BlockStairs)support).isUpsideDown()) {
            return true;
        }
        return BlockLever.isSupportValid(support, BlockFace.DOWN);
    }

    private boolean isBlockUnderValid() {
        Block support = this.down();
        if (support.getId() == 154) {
            return true;
        }
        if (support instanceof BlockWallBase || support instanceof BlockFence) {
            return true;
        }
        return BlockLever.isSupportValid(support, BlockFace.UP);
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        boolean hanging;
        if (this.getLevelBlock() instanceof BlockLiquid || this.getLevelBlockAtLayer(1) instanceof BlockLiquid) {
            return false;
        }
        boolean bl = hanging = face != BlockFace.UP && this.isBlockAboveValid() && (!this.isBlockUnderValid() || face == BlockFace.DOWN);
        if (!this.isBlockUnderValid() && !hanging) {
            return false;
        }
        this.setHanging(hanging);
        this.getLevel().setBlock((Vector3)this, this, true, true);
        return true;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (!this.isHanging()) {
                if (!this.isBlockUnderValid()) {
                    this.level.useBreakOn(this, ItemTool.getBestTool(this.getToolType()));
                }
            } else if (!this.isBlockAboveValid()) {
                this.level.useBreakOn(this, ItemTool.getBestTool(this.getToolType()));
            }
            return type;
        }
        return 0;
    }

    @Override
    public int getLightLevel() {
        return 15;
    }

    @Override
    public double getResistance() {
        return 3.5;
    }

    @Override
    public double getHardness() {
        return 3.5;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public double getMinX() {
        return this.x + 0.3125;
    }

    @Override
    public double getMinY() {
        return this.y + (!this.isHanging() ? 0.0 : 0.0625);
    }

    @Override
    public double getMinZ() {
        return this.z + 0.3125;
    }

    @Override
    public double getMaxX() {
        return this.x + 0.6875;
    }

    @Override
    public double getMaxY() {
        return this.y + (!this.isHanging() ? 0.4375 : 0.5);
    }

    @Override
    public double getMaxZ() {
        return this.z + 0.6875;
    }

    @Override
    public boolean canPassThrough() {
        return false;
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        return this;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.IRON_BLOCK_COLOR;
    }

    @Override
    @PowerNukkitOnly
    public int getToolTier() {
        return 1;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isHanging() {
        return this.getBooleanValue(HANGING);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setHanging(boolean hanging) {
        this.setBooleanValue(HANGING, hanging);
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }
}

