/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.event.block.BlockSpreadEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Sound;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;

public class BlockMycelium
extends BlockSolid {
    @Override
    public String getName() {
        return "Mycelium";
    }

    @Override
    public int getId() {
        return 110;
    }

    @Override
    public int getToolType() {
        return 2;
    }

    @Override
    public double getHardness() {
        return 0.6;
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{new ItemBlock(Block.get(3))};
    }

    @Override
    public int onUpdate(int type) {
        if (type == 2 && this.getLevel().getFullLight(this.add(0.0, 1.0, 0.0)) >= 9) {
            NukkitRandom random = new NukkitRandom();
            this.x = random.nextRange((int)this.x - 1, (int)this.x + 1);
            this.y = random.nextRange((int)this.y - 1, (int)this.y + 1);
            this.z = random.nextRange((int)this.z - 1, (int)this.z + 1);
            Block block = this.getLevel().getBlock(new Vector3(this.x, this.y, this.z));
            if (block.getId() == 3 && block.getDamage() == 0 && block.up().isTransparent()) {
                BlockSpreadEvent ev = new BlockSpreadEvent(block, this, Block.get(110));
                Server.getInstance().getPluginManager().callEvent(ev);
                if (!ev.isCancelled()) {
                    this.getLevel().setBlock(block, ev.getNewState());
                }
            }
        }
        return 0;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.PURPLE_BLOCK_COLOR;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (!this.up().canBeReplaced()) {
            return false;
        }
        if (item.isShovel()) {
            item.useOn(this);
            this.getLevel().setBlock(this, Block.get(198));
            if (player != null) {
                player.getLevel().addSound(player, Sound.USE_GRASS);
            }
            return true;
        }
        return false;
    }
}

