/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.IntBlockProperty;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemNetherWart;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.Random;
import javax.annotation.Nonnull;

public class BlockNetherWart
extends BlockFlowable {
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final IntBlockProperty AGE = new IntBlockProperty("age", false, 3);
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(AGE);

    public BlockNetherWart() {
        this(0);
    }

    public BlockNetherWart(int meta) {
        super(meta);
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        Block down = this.down();
        if (down.getId() == 88) {
            this.getLevel().setBlock((Vector3)block, this, true, true);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (this.down().getId() == 88) return 0;
            this.getLevel().useBreakOn(this);
            return 1;
        }
        if (type != 2) return 0;
        if (new Random().nextInt(10) != 1) return 2;
        if (this.getDamage() >= 3) return 0;
        BlockNetherWart block = (BlockNetherWart)this.clone();
        block.setDamage(block.getDamage() + 1);
        BlockGrowEvent ev = new BlockGrowEvent(this, block);
        Server.getInstance().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) return 2;
        this.getLevel().setBlock((Vector3)this, ev.getNewState(), true, true);
        return 0;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.RED_BLOCK_COLOR;
    }

    @Override
    public String getName() {
        return "Nether Wart Block";
    }

    @Override
    public int getId() {
        return 115;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (this.getDamage() == 3) {
            return new Item[]{new ItemNetherWart((Integer)0, 2 + (int)(Math.random() * 3.0))};
        }
        return new Item[]{new ItemNetherWart()};
    }

    @Override
    public Item toItem() {
        return new ItemNetherWart();
    }
}

