/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.item.Item;
import cn.nukkit.item.MinecraftItemID;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.math.NukkitRandom;
import java.util.concurrent.ThreadLocalRandom;

public class BlockOreLapis
extends BlockSolid {
    @Override
    public int getId() {
        return 21;
    }

    @Override
    public double getHardness() {
        return 3.0;
    }

    @Override
    public double getResistance() {
        return 5.0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    @PowerNukkitOnly
    public int getToolTier() {
        return 3;
    }

    @Override
    public String getName() {
        return "Lapis Lazuli Ore";
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe() && item.getTier() >= this.getToolTier()) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int count = 4 + random.nextInt(5);
            Enchantment fortune = item.getEnchantment(18);
            if (fortune != null && fortune.getLevel() >= 1) {
                int i = random.nextInt(fortune.getLevel() + 2) - 1;
                if (i < 0) {
                    i = 0;
                }
                count *= i + 1;
            }
            return new Item[]{MinecraftItemID.LAPIS_LAZULI.get(count)};
        }
        return Item.EMPTY_ARRAY;
    }

    @Override
    public int getDropExp() {
        return new NukkitRandom().nextRange(2, 5);
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }
}

