/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockPistonHead;
import cn.nukkit.block.BlockRedstoneTorch;
import cn.nukkit.block.BlockRedstoneTorchUnlit;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.block.BlockTorch;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityMovingBlock;
import cn.nukkit.blockentity.BlockEntityPistonArm;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.BlockStateRegistry;
import cn.nukkit.event.block.BlockPistonEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Level;
import cn.nukkit.level.Position;
import cn.nukkit.level.Sound;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.RedstoneComponent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@PowerNukkitDifference.DifferenceList(value={@PowerNukkitDifference(info="Implements RedstoneComponent.", since="1.4.0.0-PN"), @PowerNukkitDifference(since="1.4.0.0-PN", info="Implements BlockEntityHolder only in PowerNukkit")})
public abstract class BlockPistonBase
extends BlockSolidMeta
implements RedstoneComponent,
Faceable,
BlockEntityHolder<BlockEntityPistonArm> {
    @Generated
    private static final Logger log = LogManager.getLogger(BlockPistonBase.class);
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = CommonBlockProperties.FACING_DIRECTION_BLOCK_PROPERTIES;
    public boolean sticky;

    public BlockPistonBase() {
        this(0);
    }

    public BlockPistonBase(int meta) {
        super(meta);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "PistonArm";
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityPistonArm> getBlockEntityClass() {
        return BlockEntityPistonArm.class;
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    @PowerNukkitDifference(info="Using new method for checking if powered", since="1.4.0.0-PN")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        CompoundTag nbt;
        BlockEntityPistonArm piston;
        if (player != null) {
            if (Math.abs((double)player.getFloorX() - this.x) <= 1.0 && Math.abs((double)player.getFloorZ() - this.z) <= 1.0) {
                double y = player.y + (double)player.getEyeHeight();
                if (y - this.y > 2.0) {
                    this.setDamage(BlockFace.UP.getIndex());
                } else if (this.y - y > 0.0) {
                    this.setDamage(BlockFace.DOWN.getIndex());
                } else {
                    this.setDamage(player.getHorizontalFacing().getIndex());
                }
            } else {
                this.setDamage(player.getHorizontalFacing().getIndex());
            }
        }
        if (this.level.getBlockEntity(this) != null) {
            BlockEntity blockEntity = this.level.getBlockEntity(this);
            log.warn("Found unused BlockEntity at world={} x={} y={} z={} whilst attempting to place piston, closing it.", (Object)blockEntity.getLevel().getName(), (Object)blockEntity.getX(), (Object)blockEntity.getY(), (Object)blockEntity.getZ());
            blockEntity.saveNBT();
            blockEntity.close();
        }
        if ((piston = (BlockEntityPistonArm)BlockEntityHolder.setBlockAndCreateEntity(this, true, true, nbt = new CompoundTag().putInt("facing", this.getBlockFace().getIndex()).putBoolean("Sticky", this.sticky).putBoolean("powered", this.isGettingPower()), new Object[0])) == null) {
            return false;
        }
        this.checkState(piston.powered);
        return true;
    }

    @Override
    public boolean onBreak(Item item) {
        this.level.setBlock((Vector3)this, new BlockAir(), true, true);
        Block block = this.getSide(this.getBlockFace());
        if (block instanceof BlockPistonHead && ((BlockPistonHead)block).getBlockFace() == this.getBlockFace()) {
            block.onBreak(item);
        }
        return true;
    }

    public boolean isExtended() {
        BlockFace face = this.getBlockFace();
        Block block = this.getSide(face);
        return block instanceof BlockPistonHead && ((BlockPistonHead)block).getBlockFace() == face;
    }

    @Override
    @PowerNukkitDifference(info="Using new method for checking if powered + update all around redstone torches, even if the piston can't move.", since="1.4.0.0-PN")
    public int onUpdate(int type) {
        if (type != 1 && type != 6 && type != 3) {
            return 0;
        }
        if (!this.level.getServer().isRedstoneEnabled()) {
            return 0;
        }
        BlockEntityPistonArm arm = (BlockEntityPistonArm)this.getBlockEntity();
        boolean powered = this.isGettingPower();
        this.updateAroundRedstoneTorches(powered);
        if (arm == null || !arm.finished) {
            return 0;
        }
        if (arm.state % 2 == 0 && arm.powered != powered && this.checkState(powered)) {
            arm.powered = powered;
            if (arm.chunk != null) {
                arm.chunk.setChanged();
            }
        }
        return type;
    }

    private void updateAroundRedstoneTorches(boolean powered) {
        for (BlockFace side : BlockFace.values()) {
            BlockTorch.TorchAttachment torchAttachment;
            BlockTorch torch;
            Block support;
            if ((!(this.getSide(side) instanceof BlockRedstoneTorch) || !powered) && (!(this.getSide(side) instanceof BlockRedstoneTorchUnlit) || powered) || !(support = (torch = (BlockTorch)this.getSide(side)).getSide((torchAttachment = torch.getTorchAttachment()).getAttachedFace())).getLocation().equals(this.getLocation())) continue;
            torch.onUpdate(6);
        }
    }

    private boolean checkState(Boolean isPowered) {
        if (!this.level.getServer().isRedstoneEnabled()) {
            return false;
        }
        if (isPowered == null) {
            isPowered = this.isGettingPower();
        }
        if (isPowered.booleanValue() && !this.isExtended()) {
            if (!this.doMove(true)) {
                return false;
            }
            this.getLevel().addSound(this, Sound.TILE_PISTON_OUT);
            return true;
        }
        if (!isPowered.booleanValue() && this.isExtended()) {
            if (!this.doMove(false)) {
                return false;
            }
            this.getLevel().addSound(this, Sound.TILE_PISTON_IN);
            return true;
        }
        return false;
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isGettingPower() {
        BlockFace face = this.getBlockFace();
        for (BlockFace side : BlockFace.values()) {
            if (side == face) continue;
            Block b = this.getSide(side);
            if (b.getId() == 55 && b.getDamage() > 0 && b.y >= this.getY()) {
                return true;
            }
            if (!this.level.isSidePowered(b, side)) continue;
            return true;
        }
        return false;
    }

    private boolean doMove(boolean extending) {
        BlockFace direction = this.getBlockFace();
        BlocksCalculator calculator = new BlocksCalculator(this.level, this, this.getBlockFace(), extending, this.sticky);
        boolean canMove = calculator.canMove();
        if (!canMove && extending) {
            return false;
        }
        List<BlockVector3> attached = Collections.emptyList();
        BlockPistonEvent event = new BlockPistonEvent(this, direction, calculator.getBlocksToMove(), calculator.getBlocksToDestroy(), extending);
        this.level.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        if (canMove && (this.sticky || extending)) {
            List<Block> destroyBlocks = calculator.getBlocksToDestroy();
            for (int i = destroyBlocks.size() - 1; i >= 0; --i) {
                Block block = destroyBlocks.get(i);
                this.level.useBreakOn(block, null, null, false);
            }
            List<Block> newBlocks = calculator.getBlocksToMove();
            attached = newBlocks.stream().map(Vector3::asBlockVector3).collect(Collectors.toList());
            BlockFace side = extending ? direction : direction.getOpposite();
            ArrayList<CompoundTag> tags = new ArrayList<CompoundTag>();
            for (Block oldBlock : newBlocks) {
                CompoundTag tag = new CompoundTag();
                BlockEntity be = this.level.getBlockEntity(oldBlock);
                if (be != null && !(be instanceof BlockEntityMovingBlock)) {
                    be.saveNBT();
                    tag = new CompoundTag(be.namedTag.getTags());
                    be.close();
                }
                tags.add(tag);
            }
            int i = 0;
            for (Block newBlock : newBlocks) {
                Position oldPos = newBlock.add(0.0);
                newBlock.position(newBlock.add(0.0).getSide(side));
                CompoundTag nbt = new CompoundTag().putInt("pistonPosX", this.getFloorX()).putInt("pistonPosY", this.getFloorY()).putInt("pistonPosZ", this.getFloorZ()).putCompound("movingBlock", new CompoundTag().putInt("id", newBlock.getId()).putInt("meta", newBlock.getDamage()).putShort("val", newBlock.getDamage()).putString("name", BlockStateRegistry.getPersistenceName(newBlock.getId())));
                if (!((CompoundTag)tags.get(i)).isEmpty()) {
                    nbt.putCompound("movingEntity", (CompoundTag)tags.get(i));
                }
                BlockEntityHolder.setBlockAndCreateEntity((BlockEntityHolder)((Object)BlockState.of(250).getBlock(newBlock)), true, true, nbt, new Object[0]);
                if (this.level.getBlockIdAt(oldPos.getFloorX(), oldPos.getFloorY(), oldPos.getFloorZ()) != 250) {
                    this.level.setBlock(oldPos, Block.get(0));
                }
                ++i;
            }
        }
        if (extending) {
            this.level.setBlock(this.getSide(direction), this.createHead(this.getDamage()));
        }
        BlockEntityPistonArm blockEntity = (BlockEntityPistonArm)this.getOrCreateBlockEntity();
        blockEntity.move(extending, attached);
        return true;
    }

    @PowerNukkitOnly
    protected BlockPistonHead createHead(int damage) {
        return (BlockPistonHead)Block.get(this.getPistonHeadBlockId(), damage);
    }

    @PowerNukkitOnly
    public abstract int getPistonHeadBlockId();

    @PowerNukkitOnly
    public static boolean canPush(Block block, BlockFace face, boolean destroyBlocks, boolean extending) {
        if (block.getY() >= 0.0 && (face != BlockFace.DOWN || block.getY() != 0.0) && block.getY() <= 255.0 && (face != BlockFace.UP || block.getY() != 255.0)) {
            if (extending && !block.canBePushed() || !extending && !block.canBePulled()) {
                return false;
            }
            if (block.breaksWhenMoved()) {
                return destroyBlocks || block.sticksToPiston();
            }
            BlockEntity be = block.level.getBlockEntity(block);
            return be == null || be.isMovable();
        }
        return false;
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)0);
    }

    @Override
    public BlockFace getBlockFace() {
        BlockFace face = BlockFace.fromIndex(this.getDamage());
        return face.getHorizontalIndex() >= 0 ? face.getOpposite() : face;
    }

    public class BlocksCalculator {
        private final Vector3 pistonPos;
        private Vector3 armPos;
        private final Block blockToMove;
        private final BlockFace moveDirection;
        private final boolean extending;
        private final boolean sticky;
        private final List<Block> toMove = new ArrayList<Block>();
        private final List<Block> toDestroy = new ArrayList<Block>();

        public BlocksCalculator(Level level, Block block, BlockFace facing, boolean extending) {
            this(level, block, facing, extending, false);
        }

        @PowerNukkitOnly
        @Since(value="1.4.0.0-PN")
        public BlocksCalculator(Level level, Block pos, BlockFace face, boolean extending, boolean sticky) {
            this.pistonPos = pos.getLocation();
            this.extending = extending;
            this.sticky = sticky;
            if (!extending) {
                this.armPos = this.pistonPos.getSide(face);
            }
            if (extending) {
                this.moveDirection = face;
                this.blockToMove = pos.getSide(face);
            } else {
                this.moveDirection = face.getOpposite();
                this.blockToMove = sticky ? pos.getSide(face, 2) : null;
            }
        }

        public boolean canMove() {
            if (!this.sticky && !this.extending) {
                return true;
            }
            this.toMove.clear();
            this.toDestroy.clear();
            Block block = this.blockToMove;
            if (!BlockPistonBase.canPush(block, this.moveDirection, true, this.extending)) {
                return false;
            }
            if (block.breaksWhenMoved()) {
                if (this.extending || block.sticksToPiston()) {
                    this.toDestroy.add(this.blockToMove);
                }
                return true;
            }
            if (!this.addBlockLine(this.blockToMove, this.blockToMove.getSide(this.moveDirection.getOpposite()), true)) {
                return false;
            }
            for (int i = 0; i < this.toMove.size(); ++i) {
                Block b = this.toMove.get(i);
                int blockId = b.getId();
                if (blockId != 165 && blockId != 475 || this.addBranchingBlocks(b)) continue;
                return false;
            }
            return true;
        }

        private boolean addBlockLine(Block origin, Block from, boolean mainBlockLine) {
            int stickedCount;
            Block block = origin.clone();
            if (block.getId() == 0) {
                return true;
            }
            if (!mainBlockLine && (block.getId() == 165 && from.getId() == 475 || block.getId() == 475 && from.getId() == 165)) {
                return true;
            }
            if (!BlockPistonBase.canPush(origin, this.moveDirection, false, this.extending)) {
                return true;
            }
            if (origin.equals(this.pistonPos)) {
                return true;
            }
            if (this.toMove.contains(origin)) {
                return true;
            }
            if (this.toMove.size() >= 12) {
                return false;
            }
            this.toMove.add(block);
            int count = 1;
            ArrayList<Block> sticked = new ArrayList<Block>();
            while (block.getId() == 165 || block.getId() == 475) {
                Block oldBlock = block.clone();
                block = origin.getSide(this.moveDirection.getOpposite(), count);
                if (!this.extending && (block.getId() == 165 && oldBlock.getId() == 475 || block.getId() == 475 && oldBlock.getId() == 165) || block.getId() == 0 || !BlockPistonBase.canPush(block, this.moveDirection, false, this.extending) || block.equals(this.pistonPos)) break;
                if (block.breaksWhenMoved() && block.sticksToPiston()) {
                    this.toDestroy.add(block);
                    break;
                }
                if (count + this.toMove.size() > 12) {
                    return false;
                }
                ++count;
                sticked.add(block);
            }
            if ((stickedCount = sticked.size()) > 0) {
                this.toMove.addAll(Lists.reverse(sticked));
            }
            int step = 1;
            while (true) {
                Block nextBlock;
                int index;
                if ((index = this.toMove.indexOf(nextBlock = origin.getSide(this.moveDirection, step))) > -1) {
                    this.reorderListAtCollision(stickedCount, index);
                    for (int i = 0; i <= index + stickedCount; ++i) {
                        Block b = this.toMove.get(i);
                        if (b.getId() != 165 && b.getId() != 475 || this.addBranchingBlocks(b)) continue;
                        return false;
                    }
                    return true;
                }
                if (nextBlock.getId() == 0 || nextBlock.equals(this.armPos)) {
                    return true;
                }
                if (!BlockPistonBase.canPush(nextBlock, this.moveDirection, true, this.extending) || nextBlock.equals(this.pistonPos)) {
                    return false;
                }
                if (nextBlock.breaksWhenMoved()) {
                    this.toDestroy.add(nextBlock);
                    return true;
                }
                if (this.toMove.size() >= 12) {
                    return false;
                }
                this.toMove.add(nextBlock);
                ++stickedCount;
                ++step;
            }
        }

        private void reorderListAtCollision(int count, int index) {
            ArrayList<Block> list = new ArrayList<Block>(this.toMove.subList(0, index));
            ArrayList<Block> list1 = new ArrayList<Block>(this.toMove.subList(this.toMove.size() - count, this.toMove.size()));
            ArrayList<Block> list2 = new ArrayList<Block>(this.toMove.subList(index, this.toMove.size() - count));
            this.toMove.clear();
            this.toMove.addAll(list);
            this.toMove.addAll(list1);
            this.toMove.addAll(list2);
        }

        private boolean addBranchingBlocks(Block block) {
            for (BlockFace face : BlockFace.values()) {
                if (face.getAxis() == this.moveDirection.getAxis() || this.addBlockLine(block.getSide(face), block, false)) continue;
                return false;
            }
            return true;
        }

        public List<Block> getBlocksToMove() {
            return this.toMove;
        }

        public List<Block> getBlocksToDestroy() {
            return this.toDestroy;
        }
    }
}

