/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCauldron;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.OptionalBoolean;
import cn.nukkit.utils.Rail;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class BlockRail
extends BlockFlowable
implements Faceable {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BooleanBlockProperty ACTIVE = new BooleanBlockProperty("rail_data_bit", false);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperty<Rail.Orientation> UNCURVED_RAIL_DIRECTION = new ArrayBlockProperty("rail_direction", false, (Serializable[])new Rail.Orientation[]{Rail.Orientation.STRAIGHT_NORTH_SOUTH, Rail.Orientation.STRAIGHT_EAST_WEST, Rail.Orientation.ASCENDING_EAST, Rail.Orientation.ASCENDING_WEST, Rail.Orientation.ASCENDING_NORTH, Rail.Orientation.ASCENDING_SOUTH}).ordinal(true);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperty<Rail.Orientation> CURVED_RAIL_DIRECTION = new ArrayBlockProperty("rail_direction", false, (Serializable[])new Rail.Orientation[]{Rail.Orientation.STRAIGHT_NORTH_SOUTH, Rail.Orientation.STRAIGHT_EAST_WEST, Rail.Orientation.ASCENDING_EAST, Rail.Orientation.ASCENDING_WEST, Rail.Orientation.ASCENDING_NORTH, Rail.Orientation.ASCENDING_SOUTH, Rail.Orientation.CURVED_SOUTH_EAST, Rail.Orientation.CURVED_SOUTH_WEST, Rail.Orientation.CURVED_NORTH_WEST, Rail.Orientation.CURVED_NORTH_EAST}).ordinal(true);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties ACTIVABLE_PROPERTIES = new BlockProperties(UNCURVED_RAIL_DIRECTION, ACTIVE);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CURVED_RAIL_DIRECTION);
    protected boolean canBePowered = false;

    public BlockRail() {
        this(0);
    }

    public BlockRail(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Rail";
    }

    @Override
    public int getId() {
        return 66;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public double getHardness() {
        return 0.7;
    }

    @Override
    public double getResistance() {
        return 3.5;
    }

    @Override
    public boolean canPassThrough() {
        return true;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            Optional<BlockFace> ascendingDirection = this.getOrientation().ascendingDirection();
            if (!this.checkCanBePlace(this.down()) || ascendingDirection.isPresent() && !this.checkCanBePlace(this.getSide(ascendingDirection.get()))) {
                this.getLevel().useBreakOn(this);
                return 1;
            }
        }
        return 0;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.125;
    }

    @Override
    public AxisAlignedBB recalculateBoundingBox() {
        return this;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        Block down = this.down();
        if (!this.checkCanBePlace(down)) {
            return false;
        }
        Map<BlockRail, BlockFace> railsAround = this.checkRailsAroundAffected();
        ArrayList<BlockRail> rails = new ArrayList<BlockRail>(railsAround.keySet());
        ArrayList<BlockFace> faces = new ArrayList<BlockFace>(railsAround.values());
        if (railsAround.size() == 1) {
            BlockRail other = (BlockRail)rails.get(0);
            this.setRailDirection(this.connect(other, railsAround.get(other)));
        } else if (railsAround.size() == 4) {
            if (this.isAbstract()) {
                this.setRailDirection(this.connect((BlockRail)rails.get(faces.indexOf((Object)BlockFace.SOUTH)), BlockFace.SOUTH, (BlockRail)rails.get(faces.indexOf((Object)BlockFace.EAST)), BlockFace.EAST));
            } else {
                this.setRailDirection(this.connect((BlockRail)rails.get(faces.indexOf((Object)BlockFace.EAST)), BlockFace.EAST, (BlockRail)rails.get(faces.indexOf((Object)BlockFace.WEST)), BlockFace.WEST));
            }
        } else if (!railsAround.isEmpty()) {
            if (this.isAbstract()) {
                if (railsAround.size() == 2) {
                    BlockRail rail1 = (BlockRail)rails.get(0);
                    BlockRail rail2 = (BlockRail)rails.get(1);
                    this.setRailDirection(this.connect(rail1, railsAround.get(rail1), rail2, railsAround.get(rail2)));
                } else {
                    List<BlockFace> cd = Stream.of(Rail.Orientation.CURVED_SOUTH_EAST, Rail.Orientation.CURVED_NORTH_EAST, Rail.Orientation.CURVED_SOUTH_WEST).filter(o -> faces.containsAll(o.connectingDirections())).findFirst().get().connectingDirections();
                    BlockFace f12 = cd.get(0);
                    BlockFace f22 = cd.get(1);
                    this.setRailDirection(this.connect((BlockRail)rails.get(faces.indexOf((Object)f12)), f12, (BlockRail)rails.get(faces.indexOf((Object)f22)), f22));
                }
            } else {
                BlockFace f = (BlockFace)((Object)faces.stream().min((f1, f2) -> f1.getIndex() < f2.getIndex() ? 1 : (this.x == this.y ? 0 : -1)).get());
                BlockFace fo = f.getOpposite();
                if (faces.contains((Object)fo)) {
                    this.setRailDirection(this.connect((BlockRail)rails.get(faces.indexOf((Object)f)), f, (BlockRail)rails.get(faces.indexOf((Object)fo)), fo));
                } else {
                    this.setRailDirection(this.connect((BlockRail)rails.get(faces.indexOf((Object)f)), f));
                }
            }
        }
        this.level.setBlock((Vector3)this, this, true, true);
        if (!this.isAbstract()) {
            this.level.scheduleUpdate(this, this, 0);
        }
        return true;
    }

    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed support logic")
    private boolean checkCanBePlace(Block check) {
        if (check == null) {
            return false;
        }
        return check.isSolid(BlockFace.UP) || check instanceof BlockCauldron;
    }

    private Rail.Orientation connect(BlockRail rail1, BlockFace face1, BlockRail rail2, BlockFace face2) {
        this.connect(rail1, face1);
        this.connect(rail2, face2);
        if (face1.getOpposite() == face2) {
            int delta1 = (int)(this.y - rail1.y);
            int delta2 = (int)(this.y - rail2.y);
            if (delta1 == -1) {
                return Rail.Orientation.ascending(face1);
            }
            if (delta2 == -1) {
                return Rail.Orientation.ascending(face2);
            }
        }
        return Rail.Orientation.straightOrCurved(face1, face2);
    }

    private Rail.Orientation connect(BlockRail other, BlockFace face) {
        int delta = (int)(this.y - other.y);
        Map<BlockRail, BlockFace> rails = other.checkRailsConnected();
        if (rails.isEmpty()) {
            other.setOrientation(delta == 1 ? Rail.Orientation.ascending(face.getOpposite()) : Rail.Orientation.straight(face));
            return delta == -1 ? Rail.Orientation.ascending(face) : Rail.Orientation.straight(face);
        }
        if (rails.size() == 1) {
            BlockFace faceConnected = rails.values().iterator().next();
            if (other.isAbstract() && faceConnected != face) {
                other.setOrientation(Rail.Orientation.curved(face.getOpposite(), faceConnected));
                return delta == -1 ? Rail.Orientation.ascending(face) : Rail.Orientation.straight(face);
            }
            if (faceConnected == face) {
                if (!other.getOrientation().isAscending()) {
                    other.setOrientation(delta == 1 ? Rail.Orientation.ascending(face.getOpposite()) : Rail.Orientation.straight(face));
                }
                return delta == -1 ? Rail.Orientation.ascending(face) : Rail.Orientation.straight(face);
            }
            if (other.getOrientation().hasConnectingDirections(BlockFace.NORTH, BlockFace.SOUTH)) {
                other.setOrientation(delta == 1 ? Rail.Orientation.ascending(face.getOpposite()) : Rail.Orientation.straight(face));
                return delta == -1 ? Rail.Orientation.ascending(face) : Rail.Orientation.straight(face);
            }
        }
        return Rail.Orientation.STRAIGHT_NORTH_SOUTH;
    }

    private Map<BlockRail, BlockFace> checkRailsAroundAffected() {
        Map<BlockRail, BlockFace> railsAround = this.checkRailsAround(Arrays.asList(BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH));
        return railsAround.keySet().stream().filter(r -> r.checkRailsConnected().size() != 2).collect(Collectors.toMap(r -> r, railsAround::get));
    }

    private Map<BlockRail, BlockFace> checkRailsAround(Collection<BlockFace> faces) {
        HashMap<BlockRail, BlockFace> result = new HashMap<BlockRail, BlockFace>();
        faces.forEach((? super T f) -> {
            Block b = this.getSide((BlockFace)((Object)f));
            Stream.of(b, b.up(), b.down()).filter(Rail::isRailBlock).forEach((? super T block) -> result.put((BlockRail)block, (BlockFace)((Object)f)));
        });
        return result;
    }

    protected Map<BlockRail, BlockFace> checkRailsConnected() {
        Map<BlockRail, BlockFace> railsAround = this.checkRailsAround(this.getOrientation().connectingDirections());
        return railsAround.keySet().stream().filter(r -> r.getOrientation().hasConnectingDirections(((BlockFace)((Object)((Object)railsAround.get(r)))).getOpposite())).collect(Collectors.toMap(r -> r, railsAround::get));
    }

    public boolean isAbstract() {
        return this.getId() == 66;
    }

    public boolean canPowered() {
        return this.canBePowered;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public final Rail.Orientation getRailDirection() {
        return this.getOrientation();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setRailDirection(Rail.Orientation orientation) {
        this.setPropertyValue(CURVED_RAIL_DIRECTION.getName(), (Serializable)((Object)orientation));
    }

    public Rail.Orientation getOrientation() {
        return (Rail.Orientation)((Object)this.getPropertyValue(CURVED_RAIL_DIRECTION.getName()));
    }

    public void setOrientation(Rail.Orientation o) {
        if (o != this.getOrientation()) {
            this.setRailDirection(o);
            this.level.setBlock((Vector3)this, this, false, true);
        }
    }

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", by="PowerNukkit", reason="This hack is no longer needed after the block state implementation and is no longer maintained")
    public int getRealMeta() {
        if (!this.isAbstract()) {
            return this.getDamage() & 7;
        }
        return this.getDamage();
    }

    public boolean isActive() {
        return this.getProperties().contains(ACTIVE) && this.getBooleanValue(ACTIVE);
    }

    public void setActive(boolean active) {
        if (this.getProperties().contains(ACTIVE)) {
            this.setRailActive(active);
        }
        this.level.setBlock((Vector3)this, this, true, true);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public OptionalBoolean isRailActive() {
        return this.getProperties().contains(ACTIVE) ? OptionalBoolean.of(this.getBooleanValue(ACTIVE)) : OptionalBoolean.empty();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setRailActive(boolean active) throws NoSuchElementException {
        if (!active && !this.getProperties().contains(ACTIVE)) {
            return;
        }
        this.setBooleanValue(ACTIVE, active);
    }

    @Override
    public Item toItem() {
        return new ItemBlock(this, (Integer)0);
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public boolean canBePushed() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public boolean canBePulled() {
        return true;
    }
}

