/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockRedstoneDiode;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.blockproperty.IntBlockProperty;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemRedstoneRepeater;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import javax.annotation.Nonnull;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public abstract class BlockRedstoneRepeater
extends BlockRedstoneDiode {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected static final IntBlockProperty REPEATER_DELAY = new IntBlockProperty("repeater_delay", false, 3);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.DIRECTION, REPEATER_DELAY);

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockRedstoneRepeater() {
        super(0);
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        int repeaterDelay = this.getPropertyValue(REPEATER_DELAY);
        if (repeaterDelay == 3) {
            this.setPropertyValue(REPEATER_DELAY, 0);
        } else {
            this.setPropertyValue(REPEATER_DELAY, repeaterDelay + 1);
        }
        this.level.setBlock((Vector3)this, this, true, true);
        return true;
    }

    @Override
    @PowerNukkitDifference(info="Allow to be placed on top of the walls", since="1.3.0.0-PN")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (!this.isSupportValid(this.down())) {
            return false;
        }
        this.setPropertyValue(CommonBlockProperties.DIRECTION, player != null ? BlockFace.fromHorizontalIndex(player.getDirection().getOpposite().getHorizontalIndex()) : BlockFace.SOUTH);
        if (!this.level.setBlock((Vector3)block, this, true, true)) {
            return false;
        }
        if (this.level.getServer().isRedstoneEnabled() && this.shouldBePowered()) {
            this.level.scheduleUpdate(this, 1);
        }
        return true;
    }

    @Override
    public BlockFace getFacing() {
        return this.getPropertyValue(CommonBlockProperties.DIRECTION);
    }

    @Override
    protected boolean isAlternateInput(Block block) {
        return BlockRedstoneRepeater.isDiode(block);
    }

    @Override
    public Item toItem() {
        return new ItemRedstoneRepeater();
    }

    @Override
    protected int getDelay() {
        return (1 + this.getIntValue(REPEATER_DELAY)) * 2;
    }

    @Override
    public boolean isLocked() {
        return this.getPowerOnSides() > 0;
    }
}

