/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.value.SandStoneType;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;

public class BlockSandstone
extends BlockSolidMeta {
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperty<SandStoneType> SAND_STONE_TYPE = new ArrayBlockProperty<SandStoneType>("sand_stone_type", true, SandStoneType.class);
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(SAND_STONE_TYPE);
    @Deprecated
    @DeprecationDetails(since="1.5.0.0-PN", replaceWith="getSandstoneBlockType()", reason="Use the BlockProperty API instead")
    public static final int NORMAL = 0;
    @Deprecated
    @DeprecationDetails(since="1.5.0.0-PN", replaceWith="getSandstoneBlockType()", reason="Use the BlockProperty API instead")
    public static final int CHISELED = 1;
    @Deprecated
    @DeprecationDetails(since="1.5.0.0-PN", replaceWith="getSandstoneBlockType()", reason="Use the BlockProperty API instead")
    public static final int SMOOTH = 2;

    public BlockSandstone() {
        this(0);
    }

    public BlockSandstone(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 24;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @PowerNukkitOnly
    @Since(value="1.5.0.0-PN")
    public void setSandstoneType(SandStoneType sandStoneType) {
        this.setPropertyValue(SAND_STONE_TYPE, sandStoneType);
    }

    @PowerNukkitOnly
    public SandStoneType getSandstoneType() {
        return this.getPropertyValue(SAND_STONE_TYPE);
    }

    @Override
    public double getHardness() {
        return SandStoneType.SMOOTH.equals((Object)this.getSandstoneType()) ? 2.0 : 0.8;
    }

    @Override
    public double getResistance() {
        return SandStoneType.SMOOTH.equals((Object)this.getSandstoneType()) ? 6.0 : 0.8;
    }

    @Override
    public String getName() {
        return this.getSandstoneType().getEnglishName();
    }

    @Override
    @PowerNukkitOnly
    public int getToolTier() {
        return 1;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.SAND_BLOCK_COLOR;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

