/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockSlab;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.value.StoneSlab2Type;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;

public class BlockSlabRedSandstone
extends BlockSlab {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(StoneSlab2Type.PROPERTY, TOP_SLOT_PROPERTY);
    public static final int RED_SANDSTONE = 0;
    public static final int PURPUR = 1;
    @PowerNukkitOnly
    public static final int PRISMARINE = 2;
    @PowerNukkitOnly
    public static final int PRISMARINE_BRICKS = 3;
    @PowerNukkitOnly
    public static final int DARK_PRISMARINE = 4;
    @PowerNukkitOnly
    public static final int MOSSY_COBBLESTONE = 5;
    @PowerNukkitOnly
    public static final int SMOOTH_SANDSTONE = 6;
    @PowerNukkitOnly
    public static final int RED_NETHER_BRICK = 7;

    public BlockSlabRedSandstone() {
        this(0);
    }

    public BlockSlabRedSandstone(int meta) {
        super(meta, 181);
    }

    @Override
    public int getId() {
        return 182;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    @PowerNukkitOnly
    public String getSlabName() {
        return this.getSlabType().getEnglishName();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public StoneSlab2Type getSlabType() {
        return this.getPropertyValue(StoneSlab2Type.PROPERTY);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setSlabType(StoneSlab2Type type) {
        this.setPropertyValue(StoneSlab2Type.PROPERTY, type);
    }

    @Override
    @PowerNukkitOnly
    public boolean isSameType(BlockSlab slab) {
        return slab.getId() == this.getId() && this.getSlabType().equals((Object)slab.getPropertyValue(StoneSlab2Type.PROPERTY));
    }

    @Override
    public BlockColor getColor() {
        return this.getSlabType().getColor();
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    @PowerNukkitOnly
    public int getToolTier() {
        return 1;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

