/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockWallBase;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.value.CrackState;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.entity.mob.EntityGhast;
import cn.nukkit.entity.mob.EntityPhantom;
import cn.nukkit.entity.passive.EntityBat;
import cn.nukkit.entity.passive.EntityChicken;
import cn.nukkit.entity.passive.EntityTurtle;
import cn.nukkit.event.Event;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.event.block.BlockPlaceEvent;
import cn.nukkit.event.block.TurtleEggHatchEvent;
import cn.nukkit.event.entity.CreatureSpawnEvent;
import cn.nukkit.event.entity.EntityInteractEvent;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.Sound;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.MathHelper;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitOnly
public class BlockTurtleEgg
extends BlockFlowable {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperty<Integer> EGG_COUNT = new ArrayBlockProperty("turtle_egg_count", false, (Serializable[])new Integer[]{1, 2, 3, 4}, 2, "turtle_egg_count", false, new String[]{"one_egg", "two_egg", "three_egg", "four_egg"});
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final ArrayBlockProperty<CrackState> CRACK_STATE = new ArrayBlockProperty<CrackState>("cracked_state", false, CrackState.class);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(EGG_COUNT, CRACK_STATE);
    @Deprecated
    @PowerNukkitOnly
    @DeprecationDetails(since="1.4.0.0-PN", reason="New property system", replaceWith="CrackState.NO_CRACKS")
    public static final int CRACK_STATE_NO_CRACKS = 0;
    @Deprecated
    @PowerNukkitOnly
    @DeprecationDetails(since="1.4.0.0-PN", reason="New property system", replaceWith="CrackState.CRACKED")
    public static final int CRACK_STATE_CRACKED = 1;
    @Deprecated
    @PowerNukkitOnly
    @DeprecationDetails(since="1.4.0.0-PN", reason="New property system", replaceWith="CrackState.MAX_CRACKED")
    public static final int CRACK_STATE_MAX_CRACKED = 2;

    @PowerNukkitOnly
    public BlockTurtleEgg() {
        this(0);
    }

    @PowerNukkitOnly
    public BlockTurtleEgg(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 414;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getName() {
        return "Turtle Egg";
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public CrackState getCracks() {
        return this.getPropertyValue(CRACK_STATE);
    }

    @PowerNukkitOnly
    public void setCracks(@Nullable CrackState cracks) {
        this.setPropertyValue(CRACK_STATE, cracks);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    public double getHardness() {
        return 0.5;
    }

    @Override
    public double getResistance() {
        return 2.5;
    }

    @PowerNukkitOnly
    public int getEggCount() {
        return this.getPropertyValue(EGG_COUNT);
    }

    @PowerNukkitOnly
    public void setEggCount(int eggCount) {
        this.setPropertyValue(EGG_COUNT, eggCount);
    }

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Magic values", replaceWith="getCracks()")
    @PowerNukkitOnly
    public int getCrackState() {
        return Math.min(this.getDamage() >> 2 & 3, 2);
    }

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Magic values", replaceWith="setCracks(CrackState)")
    @PowerNukkitOnly
    public void setCrackState(int crackState) {
        crackState = MathHelper.clamp(crackState, 0, 2);
        this.setDamage(this.getDamage() & (DATA_MASK ^ 0xC) | crackState << 2);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (!(item.getBlock() == null || item.getBlockId() != 414 || player != null && player.isSneaking())) {
            int eggCount = this.getEggCount();
            if (eggCount >= 4) {
                return false;
            }
            Block newState = this.getCurrentState().withProperty(EGG_COUNT, eggCount + 1).getBlock(this);
            BlockPlaceEvent placeEvent = new BlockPlaceEvent(player, newState, this, this.down(), item);
            if (placeEvent.isCancelled()) {
                return false;
            }
            if (!this.level.setBlock((Vector3)this, placeEvent.getBlock(), true, true)) {
                return false;
            }
            Block placeBlock = placeEvent.getBlock();
            this.level.addLevelSoundEvent(this, 6, placeBlock.getRuntimeId());
            item.setCount(item.getCount() - 1);
            if (this.down().getId() == 12) {
                this.level.addParticle(new BoneMealParticle(this));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public double getMinX() {
        return this.x + 0.1875;
    }

    @Override
    public double getMinZ() {
        return this.z + 0.1875;
    }

    @Override
    public double getMaxX() {
        return this.x + 0.75;
    }

    @Override
    public double getMaxZ() {
        return this.z + 0.75;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.4375;
    }

    @Override
    protected AxisAlignedBB recalculateCollisionBoundingBox() {
        return new SimpleAxisAlignedBB(this.getMinX(), this.getMinY(), this.getMinZ(), this.getMaxX(), this.getMaxY() + 0.25, this.getMaxZ());
    }

    @Override
    public int onUpdate(int type) {
        if (type == 2) {
            if (this.down().getId() == 12) {
                float celestialAngle = this.level.calculateCelestialAngle(this.level.getTime(), 1.0f);
                ThreadLocalRandom random = ThreadLocalRandom.current();
                if (0.7 > (double)celestialAngle && (double)celestialAngle > 0.65 || random.nextInt(500) == 0) {
                    CrackState crackState = this.getCracks();
                    if (crackState != CrackState.MAX_CRACKED) {
                        BlockTurtleEgg newState = this.clone();
                        newState.setCracks(crackState.getNext());
                        BlockGrowEvent event = new BlockGrowEvent(this, newState);
                        this.level.getServer().getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            this.level.addSound(this, Sound.BLOCK_TURTLE_EGG_CRACK, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                            this.level.setBlock((Vector3)this, event.getNewState(), true, true);
                        }
                    } else {
                        this.hatch();
                    }
                }
            }
            return type;
        }
        return 0;
    }

    @PowerNukkitOnly
    public void hatch() {
        this.hatch(this.getEggCount());
    }

    @PowerNukkitOnly
    public void hatch(int eggs) {
        this.hatch(eggs, new BlockAir());
    }

    @PowerNukkitOnly
    @PowerNukkitDifference(info="Using new method to play sounds", since="1.4.0.0-PN")
    public void hatch(int eggs, Block newState) {
        TurtleEggHatchEvent turtleEggHatchEvent = new TurtleEggHatchEvent(this, eggs, newState);
        turtleEggHatchEvent.setCancelled(true);
        this.level.getServer().getPluginManager().callEvent(turtleEggHatchEvent);
        int eggsHatching = turtleEggHatchEvent.getEggsHatching();
        if (!turtleEggHatchEvent.isCancelled()) {
            this.level.addSound(this, Sound.BLOCK_TURTLE_EGG_CRACK);
            boolean hasFailure = false;
            for (int i = 0; i < eggsHatching; ++i) {
                EntityTurtle turtle;
                this.level.addSound(this, Sound.BLOCK_TURTLE_EGG_CRACK);
                CreatureSpawnEvent creatureSpawnEvent = new CreatureSpawnEvent(74, this.add(0.3 + (double)i * 0.2, 0.0, 0.3), CreatureSpawnEvent.SpawnReason.TURTLE_EGG);
                this.level.getServer().getPluginManager().callEvent(creatureSpawnEvent);
                if (!creatureSpawnEvent.isCancelled() && (turtle = (EntityTurtle)Entity.createEntity(creatureSpawnEvent.getEntityNetworkId(), creatureSpawnEvent.getPosition(), new Object[0])) != null) {
                    turtle.setBreedingAge(-24000);
                    turtle.setHomePos(new Vector3(this.x, this.y, this.z));
                    turtle.setDataFlag(Entity.DATA_FLAGS, Entity.DATA_FLAG_BABY, true);
                    turtle.setScale(0.16f);
                    turtle.spawnToAll();
                    continue;
                }
                if (!turtleEggHatchEvent.isRecalculateOnFailure()) continue;
                turtleEggHatchEvent.setEggsHatching(turtleEggHatchEvent.getEggsHatching() - 1);
                hasFailure = true;
            }
            if (hasFailure) {
                turtleEggHatchEvent.recalculateNewState();
            }
            this.level.setBlock((Vector3)this, turtleEggHatchEvent.getNewState(), true, true);
        }
    }

    @Override
    public void onEntityCollide(Entity entity) {
        if (entity instanceof EntityLiving && !(entity instanceof EntityChicken) && !(entity instanceof EntityBat) && !(entity instanceof EntityGhast) && !(entity instanceof EntityPhantom) && entity.getY() >= this.getMaxY()) {
            Event ev = entity instanceof Player ? new PlayerInteractEvent((Player)entity, null, this, null, PlayerInteractEvent.Action.PHYSICAL) : new EntityInteractEvent(entity, this);
            ev.setCancelled(ThreadLocalRandom.current().nextInt(200) > 0);
            this.level.getServer().getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                this.level.useBreakOn(this, null, null, true);
            }
        }
    }

    @Override
    public Item toItem() {
        return new ItemBlock(new BlockTurtleEgg());
    }

    @Override
    public boolean onBreak(Item item) {
        int eggCount = this.getEggCount();
        if (item.getEnchantment(16) == null) {
            this.level.addSound(this, Sound.BLOCK_TURTLE_EGG_CRACK);
        }
        if (eggCount == 1) {
            return super.onBreak(item);
        }
        this.setEggCount(eggCount - 1);
        return this.level.setBlock((Vector3)this, this, true, true);
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (!this.isValidSupport(block.down(1, 0))) {
            return false;
        }
        if (this.level.setBlock((Vector3)this, this, true, true)) {
            if (this.down().getId() == 12) {
                this.level.addParticle(new BoneMealParticle(this));
            }
            return true;
        }
        return false;
    }

    @PowerNukkitOnly
    public boolean isValidSupport(Block support) {
        return support.isSolid(BlockFace.UP) || support instanceof BlockWallBase;
    }

    @Override
    public Item[] getDrops(Item item) {
        return Item.EMPTY_ARRAY;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean canPassThrough() {
        return false;
    }

    @Override
    public boolean canBeFlowedInto() {
        return false;
    }

    @Override
    public BlockTurtleEgg clone() {
        return (BlockTurtleEgg)super.clone();
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.SAND_BLOCK_COLOR;
    }
}

