/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockCampfire;
import cn.nukkit.blockentity.BlockEntityContainer;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.event.inventory.CampfireSmeltEvent;
import cn.nukkit.inventory.CampfireInventory;
import cn.nukkit.inventory.CampfireRecipe;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;

@PowerNukkitOnly
public class BlockEntityCampfire
extends BlockEntitySpawnable
implements InventoryHolder,
BlockEntityContainer {
    private CampfireInventory inventory;
    private int[] burnTime;
    private CampfireRecipe[] recipes;
    private boolean[] keepItem;

    @PowerNukkitOnly
    public BlockEntityCampfire(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        this.inventory = new CampfireInventory(this, InventoryType.CAMPFIRE);
        this.burnTime = new int[4];
        this.recipes = new CampfireRecipe[4];
        this.keepItem = new boolean[4];
        for (int i = 1; i <= this.burnTime.length; ++i) {
            this.burnTime[i - 1] = this.namedTag.getInt("ItemTime" + i);
            this.keepItem[i - 1] = this.namedTag.getBoolean("KeepItem1");
            if (!this.namedTag.contains("Item" + i) || !(this.namedTag.get("Item" + i) instanceof CompoundTag)) continue;
            this.inventory.setItem(i - 1, NBTIO.getItemHelper(this.namedTag.getCompound("Item" + i)));
        }
        super.initBlockEntity();
        this.scheduleUpdate();
    }

    @Override
    public boolean onUpdate() {
        boolean needsUpdate = false;
        Block block = this.getBlock();
        boolean isLit = block instanceof BlockCampfire && !((BlockCampfire)block).isExtinguished();
        for (int slot = 0; slot < this.inventory.getSize(); ++slot) {
            int burnTimeLeft;
            Item item = this.inventory.getItem(slot);
            if (item == null || item.getId() == 0 || item.getCount() <= 0) {
                this.burnTime[slot] = 0;
                this.recipes[slot] = null;
                continue;
            }
            if (this.keepItem[slot]) continue;
            CampfireRecipe recipe = this.recipes[slot];
            if (recipe == null) {
                recipe = this.server.getCraftingManager().matchCampfireRecipe(item);
                if (recipe == null) {
                    this.inventory.setItem(slot, Item.get(0));
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    this.level.dropItem(this.add(random.nextFloat(), 0.5, random.nextFloat()), item);
                    this.burnTime[slot] = 0;
                    this.recipes[slot] = null;
                    continue;
                }
                this.burnTime[slot] = 600;
                this.recipes[slot] = recipe;
            }
            if ((burnTimeLeft = this.burnTime[slot]) <= 0) {
                Item product = Item.get(recipe.getResult().getId(), recipe.getResult().getDamage(), item.getCount());
                CampfireSmeltEvent event = new CampfireSmeltEvent(this, item, product);
                if (!event.isCancelled()) {
                    this.inventory.setItem(slot, Item.get(0));
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    this.level.dropItem(this.add(random.nextFloat(), 0.5, random.nextFloat()), event.getResult());
                    this.burnTime[slot] = 0;
                    this.recipes[slot] = null;
                    continue;
                }
                if (!event.getKeepItem()) continue;
                this.keepItem[slot] = true;
                this.burnTime[slot] = 0;
                this.recipes[slot] = null;
                continue;
            }
            if (isLit) {
                int n = slot;
                this.burnTime[n] = this.burnTime[n] - 1;
                needsUpdate = true;
                continue;
            }
            this.burnTime[slot] = 600;
        }
        return needsUpdate;
    }

    @PowerNukkitOnly
    public boolean getKeepItem(int slot) {
        if (slot < 0 || slot >= this.keepItem.length) {
            return false;
        }
        return this.keepItem[slot];
    }

    @PowerNukkitOnly
    public void setKeepItem(int slot, boolean keep) {
        if (slot < 0 || slot >= this.keepItem.length) {
            return;
        }
        this.keepItem[slot] = keep;
    }

    @Override
    public void saveNBT() {
        for (int i = 1; i <= this.burnTime.length; ++i) {
            Item item = this.inventory.getItem(i - 1);
            if (item == null || item.getId() == 0 || item.getCount() <= 0) {
                this.namedTag.remove("Item" + i);
                this.namedTag.putInt("ItemTime" + i, 0);
                this.namedTag.remove("KeepItem" + i);
                continue;
            }
            this.namedTag.putCompound("Item" + i, NBTIO.putItemHelper(item));
            this.namedTag.putInt("ItemTime" + i, this.burnTime[i - 1]);
            this.namedTag.putBoolean("KeepItem" + i, this.keepItem[i - 1]);
        }
        super.saveNBT();
    }

    @PowerNukkitOnly
    public void setRecipe(int index, CampfireRecipe recipe) {
        this.recipes[index] = recipe;
    }

    @Override
    public void close() {
        if (!this.closed) {
            for (Player player : new HashSet<Player>(this.getInventory().getViewers())) {
                player.removeWindow(this.getInventory());
            }
            super.close();
        }
    }

    @Override
    public void onBreak() {
        for (Item content : this.inventory.getContents().values()) {
            this.level.dropItem(this, content);
        }
    }

    @Override
    public String getName() {
        return "Campfire";
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag c = new CompoundTag().putString("id", "Campfire").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        for (int i = 1; i <= this.burnTime.length; ++i) {
            Item item = this.inventory.getItem(i - 1);
            if (item == null || item.getId() == 0 || item.getCount() <= 0) {
                c.remove("Item" + i);
                continue;
            }
            c.putCompound("Item" + i, NBTIO.putItemHelper(item));
        }
        return c;
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.getBlock().getId() == 464;
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public Item getItem(int index) {
        if (index < 0 || index >= this.getSize()) {
            return new ItemBlock(new BlockAir(), (Integer)0, 0);
        }
        CompoundTag data = this.namedTag.getCompound("Item" + (index + 1));
        return NBTIO.getItemHelper(data);
    }

    @Override
    public void setItem(int index, Item item) {
        if (index < 0 || index >= this.getSize()) {
            return;
        }
        CompoundTag nbt = NBTIO.putItemHelper(item);
        this.namedTag.putCompound("Item" + (index + 1), nbt);
    }

    @Override
    public CampfireInventory getInventory() {
        return this.inventory;
    }
}

