/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockproperty;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyMetaException;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyPersistenceValueException;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyValueException;
import cn.nukkit.math.NukkitMath;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class UnsignedIntBlockProperty
extends BlockProperty<Integer> {
    private static final long serialVersionUID = 7896101036099245755L;
    private final long minValue;
    private final long maxValue;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public UnsignedIntBlockProperty(String name, boolean exportedToItem, int maxValue, int minValue, int bitSize, String persistenceName) {
        super(name, exportedToItem, bitSize, persistenceName);
        long unsignedMinValue = UnsignedIntBlockProperty.removeSign(minValue);
        long unsignedMaxValue = UnsignedIntBlockProperty.removeSign(maxValue);
        long delta = unsignedMaxValue - unsignedMinValue;
        Preconditions.checkArgument((delta > 0L ? 1 : 0) != 0, (String)"maxValue must be higher than minValue. Got min:%s and max:%s", (long)unsignedMinValue, (long)unsignedMaxValue);
        long mask = UnsignedIntBlockProperty.removeSign(-1 >>> 32 - bitSize);
        Preconditions.checkArgument((delta <= mask ? 1 : 0) != 0, (String)"The data range from %s to %s can't be stored in %s bits", (Object)unsignedMinValue, (Object)unsignedMaxValue, (Object)bitSize);
        this.minValue = unsignedMinValue;
        this.maxValue = unsignedMaxValue;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public UnsignedIntBlockProperty(String name, boolean exportedToItem, int maxValue, int minValue, int bitSize) {
        this(name, exportedToItem, maxValue, minValue, bitSize, name);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public UnsignedIntBlockProperty(String name, boolean exportedToItem, int maxValue, int minValue) {
        this(name, exportedToItem, maxValue, minValue, NukkitMath.bitLength(maxValue - minValue));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public UnsignedIntBlockProperty(String name, boolean exportedToItem, int maxValue) {
        this(name, exportedToItem, maxValue, 0);
    }

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public UnsignedIntBlockProperty copy() {
        return new UnsignedIntBlockProperty(this.getName(), this.isExportedToItem(), (int)this.getMaxValue(), (int)this.getMinValue(), this.getBitSize(), this.getPersistenceName());
    }

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public UnsignedIntBlockProperty exportingToItems(boolean exportedToItem) {
        return new UnsignedIntBlockProperty(this.getName(), exportedToItem, (int)this.getMaxValue(), (int)this.getMinValue(), this.getBitSize(), this.getPersistenceName());
    }

    private static long removeSign(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    private static int addSign(long value) {
        return (int)(value & 0xFFFFFFFFL);
    }

    @Override
    @PowerNukkitOnly
    public int getMetaForValue(@Nullable Integer value) {
        if (value == null) {
            return 0;
        }
        long unsigned = UnsignedIntBlockProperty.removeSign(value);
        try {
            this.validateDirectly(unsigned);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidBlockPropertyValueException(this, null, (Serializable)value, e);
        }
        return (int)(unsigned - this.minValue);
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    public Integer getValueForMeta(int meta) {
        return this.getIntValueForMeta(meta);
    }

    @Override
    @PowerNukkitOnly
    public int getIntValueForMeta(int meta) {
        try {
            this.validateMetaDirectly(meta);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)meta, (Number)meta, e);
        }
        return (int)(this.minValue + (long)meta);
    }

    @Override
    @PowerNukkitOnly
    public String getPersistenceValueForMeta(int meta) {
        return String.valueOf(UnsignedIntBlockProperty.removeSign(this.getIntValueForMeta(meta)));
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getMetaForPersistenceValue(@Nonnull String persistenceValue) {
        try {
            return this.getMetaForValue(UnsignedIntBlockProperty.addSign(Long.parseLong(persistenceValue)));
        }
        catch (InvalidBlockPropertyValueException | NumberFormatException e) {
            throw new InvalidBlockPropertyPersistenceValueException(this, null, persistenceValue, e);
        }
    }

    @Override
    @PowerNukkitOnly
    protected void validateDirectly(@Nullable Integer value) {
        if (value == null) {
            return;
        }
        this.validateDirectly(UnsignedIntBlockProperty.removeSign(value));
    }

    @Override
    private void validateDirectly(long unsigned) {
        Preconditions.checkArgument((unsigned >= this.minValue ? 1 : 0) != 0, (String)"New value (%s) must be higher or equals to %s", (long)unsigned, (long)this.minValue);
        Preconditions.checkArgument((this.maxValue >= unsigned ? 1 : 0) != 0, (String)"New value (%s) must be less or equals to %s", (long)unsigned, (long)this.maxValue);
    }

    @Override
    @PowerNukkitOnly
    protected void validateMetaDirectly(int meta) {
        long max = this.maxValue - this.minValue;
        Preconditions.checkArgument((0 <= meta && (long)meta <= max ? 1 : 0) != 0, (String)"The meta %s is outside the range of 0 .. ", (int)meta, (long)max);
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    public Class<Integer> getValueClass() {
        return Integer.class;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public long getMaxValue() {
        return this.maxValue;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public long getMinValue() {
        return this.minValue;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Integer getDefaultValue() {
        return (int)this.minValue;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean isDefaultValue(@Nullable Integer value) {
        return value == null || UnsignedIntBlockProperty.removeSign(value) == this.minValue;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean isDefaultIntValue(int value) {
        return UnsignedIntBlockProperty.removeSign(value) == this.minValue;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getDefaultIntValue() {
        return (int)this.minValue;
    }
}

