/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockproperty.value;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.utils.BlockColor;
import java.io.Serializable;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public enum WoodType {
    OAK(BlockColor.WOOD_BLOCK_COLOR),
    SPRUCE(BlockColor.SPRUCE_BLOCK_COLOR),
    BIRCH(BlockColor.SAND_BLOCK_COLOR),
    JUNGLE(BlockColor.DIRT_BLOCK_COLOR),
    ACACIA(BlockColor.ORANGE_BLOCK_COLOR),
    DARK_OAK(BlockColor.BROWN_BLOCK_COLOR, "Dark Oak");

    private final BlockColor color;
    private final String englishName;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final ArrayBlockProperty<WoodType> PROPERTY;

    private WoodType(BlockColor color) {
        this.color = color;
        this.englishName = this.name().substring(0, 1) + this.name().substring(1).toLowerCase();
    }

    private WoodType(BlockColor color, String name) {
        this.color = color;
        this.englishName = name;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockColor getColor() {
        return this.color;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getEnglishName() {
        return this.englishName;
    }

    static {
        PROPERTY = new ArrayBlockProperty("wood_type", true, (Serializable[])WoodType.values());
    }
}

