/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockstate;

import cn.nukkit.Server;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockUnknown;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.exception.BlockPropertyNotFoundException;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.MutableBlockState;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.HumanStringComparator;
import com.google.common.base.Preconditions;
import io.netty.util.internal.EmptyArrays;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public final class BlockStateRegistry {
    @Generated
    private static final Logger log;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final int BIG_META_MASK = -1;
    private static final ExecutorService asyncStateRemover;
    private static final Pattern BLOCK_ID_NAME_PATTERN;
    private static final Registration updateBlockRegistration;
    private static final Map<BlockState, Registration> blockStateRegistration;
    private static final Map<String, Registration> stateIdRegistration;
    private static final Int2ObjectMap<Registration> runtimeIdRegistration;
    private static final Int2ObjectMap<String> blockIdToPersistenceName;
    private static final Map<String, Integer> persistenceNameToBlockId;
    private static final byte[] blockPaletteBytes;
    private static final List<String> knownStateIds;

    private static boolean isNameOwnerOfId(String name, int blockId) {
        return blockId != -1 && !name.equals("minecraft:wood") || blockId == 467;
    }

    @Nonnull
    private static String getStateId(CompoundTag block) {
        TreeMap<String, String> propertyMap = new TreeMap<String, String>(HumanStringComparator.getInstance());
        for (Tag tag : block.getCompound("states").getAllTags()) {
            propertyMap.put(tag.getName(), tag.parseValue().toString());
        }
        String blockName = block.getString("name").toLowerCase(Locale.ENGLISH);
        Preconditions.checkArgument((!blockName.isEmpty() ? 1 : 0) != 0, (Object)"Couldn't find the block name!");
        StringBuilder stateId = new StringBuilder(blockName);
        propertyMap.forEach((name, value) -> stateId.append(';').append((String)name).append('=').append((String)value));
        return stateId.toString();
    }

    @Nullable
    private static Registration findRegistrationByRuntimeId(int runtimeId) {
        return (Registration)runtimeIdRegistration.get(runtimeId);
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public static String getKnownBlockStateIdByRuntimeId(int runtimeId) {
        if (runtimeId >= 0 && runtimeId < knownStateIds.size()) {
            return knownStateIds.get(runtimeId);
        }
        return null;
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public static int getKnownRuntimeIdByBlockStateId(String stateId) {
        BlockState state;
        int result = knownStateIds.indexOf(stateId);
        if (result != -1) {
            return result;
        }
        try {
            state = BlockState.of(stateId);
        }
        catch (IllegalArgumentException | IllegalStateException | NoSuchElementException ignored) {
            return -1;
        }
        String fullStateId = state.getStateId();
        return knownStateIds.indexOf(fullStateId);
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static BlockState getBlockStateByRuntimeId(int runtimeId) {
        Registration registration = BlockStateRegistry.findRegistrationByRuntimeId(runtimeId);
        if (registration == null) {
            return null;
        }
        BlockState state = registration.state;
        if (state != null) {
            return state;
        }
        CompoundTag originalBlock = registration.originalBlock;
        if (originalBlock != null && (state = BlockStateRegistry.buildStateFromCompound(originalBlock)) != null) {
            registration.state = state;
            registration.originalBlock = null;
        }
        return state;
    }

    @Nullable
    private static BlockState buildStateFromCompound(CompoundTag block) {
        String name = block.getString("name").toLowerCase(Locale.ENGLISH);
        Integer id = BlockStateRegistry.getBlockId(name);
        if (id == null) {
            return null;
        }
        BlockState state = BlockState.of(id);
        CompoundTag properties = block.getCompound("states");
        for (Tag tag : properties.getAllTags()) {
            state = state.withProperty(tag.getName(), tag.parseValue().toString());
        }
        return state;
    }

    private static NoSuchElementException runtimeIdNotRegistered(int runtimeId) {
        return new NoSuchElementException("The block id for the runtime id " + runtimeId + " is not registered");
    }

    @PowerNukkitOnly
    @Since(value="1.5.2.0-PN")
    public static int getBlockIdByRuntimeId(int runtimeId) {
        Registration registration = BlockStateRegistry.findRegistrationByRuntimeId(runtimeId);
        if (registration == null) {
            throw BlockStateRegistry.runtimeIdNotRegistered(runtimeId);
        }
        BlockState state = registration.state;
        if (state != null) {
            return state.getBlockId();
        }
        CompoundTag originalBlock = registration.originalBlock;
        if (originalBlock == null) {
            throw BlockStateRegistry.runtimeIdNotRegistered(runtimeId);
        }
        try {
            state = BlockStateRegistry.buildStateFromCompound(originalBlock);
        }
        catch (BlockPropertyNotFoundException e) {
            String name = originalBlock.getString("name").toLowerCase(Locale.ENGLISH);
            Integer id = BlockStateRegistry.getBlockId(name);
            if (id == null) {
                throw BlockStateRegistry.runtimeIdNotRegistered(runtimeId);
            }
            return id;
        }
        if (state == null) {
            throw BlockStateRegistry.runtimeIdNotRegistered(runtimeId);
        }
        registration.state = state;
        registration.originalBlock = null;
        return state.getBlockId();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static int getRuntimeId(BlockState state) {
        return BlockStateRegistry.getRegistration(BlockStateRegistry.convertToNewState(state)).runtimeId;
    }

    private static BlockState convertToNewState(BlockState oldState) {
        int exactInt;
        if (oldState.getBitSize() == 4 && (oldState.getBlockId() == 17 || oldState.getBlockId() == 162) && ((exactInt = oldState.getExactIntStorage()) & 0xC) == 12) {
            int increment = oldState.getBlockId() == 17 ? 0 : 4;
            return BlockState.of(467, (exactInt & 3) + increment);
        }
        return oldState;
    }

    private static Registration getRegistration(BlockState state) {
        return blockStateRegistration.computeIfAbsent(state, BlockStateRegistry::findRegistration);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static int getRuntimeId(int blockId) {
        return BlockStateRegistry.getRuntimeId(BlockState.of(blockId));
    }

    @Deprecated
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    @DeprecationDetails(reason="The meta is limited to 32 bits", replaceWith="getRuntimeId(BlockState state)", since="1.3.0.0-PN")
    public static int getRuntimeId(int blockId, int meta) {
        return BlockStateRegistry.getRuntimeId(BlockState.of(blockId, meta));
    }

    private static Registration findRegistration(BlockState state) {
        Registration airRegistration;
        if (state.getBlockId() == 0 && (airRegistration = blockStateRegistration.get(BlockState.AIR)) != null) {
            return new Registration(state, airRegistration.runtimeId, null);
        }
        Registration registration = BlockStateRegistry.findRegistrationByStateId(state);
        BlockStateRegistry.removeStateIdsAsync(registration);
        return registration;
    }

    private static Registration findRegistrationByStateId(BlockState state) {
        Registration registration;
        try {
            registration = stateIdRegistration.remove(state.getStateId());
            if (registration != null) {
                registration.state = state;
                registration.originalBlock = null;
                return registration;
            }
        }
        catch (Exception e) {
            try {
                log.fatal("An error has occurred while trying to get the stateId of state: {}:{} - {} - {}", (Object)state.getBlockId(), (Object)state.getDataStorage(), (Object)state.getProperties(), blockIdToPersistenceName.get(state.getBlockId()), (Object)e);
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
                log.fatal("An error has occurred while trying to get the stateId of state: {}:{}", (Object)state.getBlockId(), (Object)state.getDataStorage(), (Object)e);
            }
        }
        try {
            registration = stateIdRegistration.remove(state.getLegacyStateId());
            if (registration != null) {
                registration.state = state;
                registration.originalBlock = null;
                return registration;
            }
        }
        catch (Exception e) {
            log.fatal("An error has occurred while trying to parse the legacyStateId of {}:{}", (Object)state.getBlockId(), (Object)state.getDataStorage(), (Object)e);
        }
        return BlockStateRegistry.logDiscoveryError(state);
    }

    private static void removeStateIdsAsync(@Nullable Registration registration) {
        if (registration != null && registration != updateBlockRegistration) {
            asyncStateRemover.submit(() -> stateIdRegistration.values().removeIf(r -> ((Registration)r).runtimeId == registration.runtimeId));
        }
    }

    private static Registration logDiscoveryError(BlockState state) {
        log.error("Found an unknown BlockId:Meta combination: {}:{} - {} - {} - {}, trying to repair or replacing with an \"UPDATE!\" block.", (Object)state.getBlockId(), (Object)state.getDataStorage(), (Object)state.getStateId(), (Object)state.getProperties(), blockIdToPersistenceName.get(state.getBlockId()));
        return updateBlockRegistration;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static List<String> getPersistenceNames() {
        return new ArrayList<String>(persistenceNameToBlockId.keySet());
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static String getPersistenceName(int blockId) {
        String persistenceName = (String)blockIdToPersistenceName.get(blockId);
        if (persistenceName == null) {
            String fallback = "blockid:" + blockId;
            log.warn("The persistence name of the block id {} is unknown! Using {} as an alternative!", (Object)blockId, (Object)fallback);
            BlockStateRegistry.registerPersistenceName(blockId, fallback);
            return fallback;
        }
        return persistenceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void registerPersistenceName(int blockId, String persistenceName) {
        Int2ObjectMap<String> int2ObjectMap = blockIdToPersistenceName;
        synchronized (int2ObjectMap) {
            String newName = persistenceName.toLowerCase();
            String oldName = (String)blockIdToPersistenceName.putIfAbsent(blockId, (Object)newName);
            if (oldName != null && !persistenceName.equalsIgnoreCase(oldName)) {
                throw new UnsupportedOperationException("The persistence name registration tried to replaced a name. Name:" + persistenceName + ", Old:" + oldName + ", Id:" + blockId);
            }
            Integer oldId = persistenceNameToBlockId.putIfAbsent(newName, blockId);
            if (oldId != null && blockId != oldId) {
                blockIdToPersistenceName.remove(blockId);
                throw new UnsupportedOperationException("The persistence name registration tried to replaced an id. Name:" + persistenceName + ", OldId:" + oldId + ", Id:" + blockId);
            }
        }
    }

    private static void registerStateId(CompoundTag block, int runtimeId) {
        Registration registration;
        String stateId = BlockStateRegistry.getStateId(block);
        Registration old = stateIdRegistration.putIfAbsent(stateId, registration = new Registration(null, runtimeId, block));
        if (old != null && !old.equals(registration)) {
            throw new UnsupportedOperationException("The persistence NBT registration tried to replaced a runtime id. Old:" + old + ", New:" + runtimeId + ", State:" + stateId);
        }
        runtimeIdRegistration.put(runtimeId, (Object)registration);
    }

    private static void registerState(int blockId, int meta, CompoundTag originalState, int runtimeId) {
        Registration registration;
        BlockState state = BlockState.of(blockId, meta);
        Registration old = blockStateRegistration.putIfAbsent(state, registration = new Registration(state, runtimeId, null));
        if (old != null && !registration.equals(old)) {
            throw new UnsupportedOperationException("The persistence NBT registration tried to replaced a runtime id. Old:" + old + ", New:" + runtimeId + ", State:" + state);
        }
        runtimeIdRegistration.put(runtimeId, (Object)registration);
        stateIdRegistration.remove(BlockStateRegistry.getStateId(originalState));
        stateIdRegistration.remove(state.getLegacyStateId());
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static int getBlockPaletteDataVersion() {
        byte[] obj = blockPaletteBytes;
        return obj.hashCode();
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static byte[] getBlockPaletteBytes() {
        return (byte[])blockPaletteBytes.clone();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void putBlockPaletteBytes(BinaryStream stream) {
        stream.put(blockPaletteBytes);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static int getBlockPaletteLength() {
        return blockPaletteBytes.length;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void copyBlockPaletteBytes(byte[] target, int targetIndex) {
        System.arraycopy(blockPaletteBytes, 0, target, targetIndex, blockPaletteBytes.length);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static BlockProperties getProperties(int blockId) {
        Block block;
        int fullId = blockId << Block.DATA_BITS;
        if (fullId >= Block.fullList.length || fullId < 0 || (block = Block.fullList[fullId]) == null) {
            return BlockUnknown.PROPERTIES;
        }
        return block.getProperties();
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static MutableBlockState createMutableState(int blockId) {
        return BlockStateRegistry.getProperties(blockId).createMutableState(blockId);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static MutableBlockState createMutableState(int blockId, int bigMeta) {
        MutableBlockState blockState = BlockStateRegistry.createMutableState(blockId);
        blockState.setDataStorageFromInt(bigMeta);
        return blockState;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static MutableBlockState createMutableState(int blockId, Number storage) {
        MutableBlockState blockState = BlockStateRegistry.createMutableState(blockId);
        blockState.setDataStorage(storage);
        return blockState;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static int getUpdateBlockRegistration() {
        return updateBlockRegistration.runtimeId;
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static Integer getBlockId(String persistenceName) {
        Integer blockId = persistenceNameToBlockId.get(persistenceName);
        if (blockId != null) {
            return blockId;
        }
        Matcher matcher = BLOCK_ID_NAME_PATTERN.matcher(persistenceName);
        if (matcher.matches()) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static int getFallbackRuntimeId() {
        return updateBlockRegistration.runtimeId;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static BlockState getFallbackBlockState() {
        return updateBlockRegistration.state;
    }

    @Generated
    private BlockStateRegistry() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        Object line;
        log = LogManager.getLogger(BlockStateRegistry.class);
        asyncStateRemover = Executors.newSingleThreadExecutor();
        BLOCK_ID_NAME_PATTERN = Pattern.compile("^blockid:(\\d+)$");
        blockStateRegistration = new ConcurrentHashMap<BlockState, Registration>();
        stateIdRegistration = new ConcurrentHashMap<String, Registration>();
        runtimeIdRegistration = new Int2ObjectOpenHashMap();
        blockIdToPersistenceName = new Int2ObjectOpenHashMap();
        persistenceNameToBlockId = new LinkedHashMap<String, Integer>();
        try (InputStream stream = Server.class.getClassLoader().getResourceAsStream("block_ids.csv");){
            if (stream == null) {
                throw new AssertionError((Object)"Unable to locate block_ids.csv");
            }
            int count = 0;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                while ((line = reader.readLine()) != null) {
                    ++count;
                    if (((String)(line = ((String)line).trim())).isEmpty()) continue;
                    String[] parts = ((String)line).split(",");
                    Preconditions.checkArgument((parts.length == 2 || parts[0].matches("^[0-9]+$") ? 1 : 0) != 0);
                    if (parts.length <= 1 || !parts[1].startsWith("minecraft:")) continue;
                    int id = Integer.parseInt(parts[0]);
                    blockIdToPersistenceName.put(id, (Object)parts[1]);
                    persistenceNameToBlockId.put(parts[1], id);
                }
            }
            catch (Exception e) {
                throw new IOException("Error reading the line " + count + " of the block_ids.csv", e);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        ArrayList<CompoundTag> tags = new ArrayList<CompoundTag>();
        ArrayList<String> loadingKnownStateIds = new ArrayList<String>();
        try (InputStream stream = Server.class.getClassLoader().getResourceAsStream("canonical_block_states.nbt");){
            if (stream == null) {
                throw new AssertionError((Object)"Unable to locate block state nbt");
            }
            BufferedInputStream bis = new BufferedInputStream(stream);
            line = null;
            try {
                int runtimeId = 0;
                while (bis.available() > 0) {
                    CompoundTag tag = NBTIO.read(bis, ByteOrder.BIG_ENDIAN, true);
                    tag.putInt("runtimeId", runtimeId++);
                    tag.putInt("blockId", persistenceNameToBlockId.getOrDefault(tag.getString("name").toLowerCase(), -1));
                    tags.add(tag);
                    loadingKnownStateIds.add(BlockStateRegistry.getStateId(tag));
                }
            }
            catch (Throwable runtimeId) {
                line = runtimeId;
                throw runtimeId;
            }
            finally {
                if (bis != null) {
                    if (line != null) {
                        try {
                            bis.close();
                        }
                        catch (Throwable runtimeId) {
                            ((Throwable)line).addSuppressed(runtimeId);
                        }
                    } else {
                        bis.close();
                    }
                }
            }
            knownStateIds = Arrays.asList(loadingKnownStateIds.toArray(EmptyArrays.EMPTY_STRINGS));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        Integer infoUpdateRuntimeId = null;
        HashSet<String> warned = new HashSet<String>();
        for (CompoundTag state : tags) {
            int blockId = state.getInt("blockId");
            int runtimeId = state.getInt("runtimeId");
            String name = state.getString("name").toLowerCase();
            if (name.equals("minecraft:unknown")) {
                infoUpdateRuntimeId = runtimeId;
            }
            if (BlockStateRegistry.isNameOwnerOfId(name, blockId)) {
                BlockStateRegistry.registerPersistenceName(blockId, name);
                BlockStateRegistry.registerStateId(state, runtimeId);
                continue;
            }
            if (blockId != -1) continue;
            if (warned.add(name)) {
                log.warn("Unknown block id for the block named {}", (Object)name);
            }
            BlockStateRegistry.registerStateId(state, runtimeId);
        }
        if (infoUpdateRuntimeId == null) {
            throw new IllegalStateException("Could not find the minecraft:info_update runtime id!");
        }
        updateBlockRegistration = BlockStateRegistry.findRegistrationByRuntimeId(infoUpdateRuntimeId);
        try {
            blockPaletteBytes = NBTIO.write(tags, ByteOrder.LITTLE_ENDIAN, true);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class Registration {
        @Nullable
        private BlockState state;
        private final int runtimeId;
        @Nullable
        private CompoundTag originalBlock;

        @Generated
        public Registration(@Nullable BlockState state, int runtimeId, @Nullable CompoundTag originalBlock) {
            this.state = state;
            this.runtimeId = runtimeId;
            this.originalBlock = originalBlock;
        }

        @Generated
        public String toString() {
            return "BlockStateRegistry.Registration(state=" + this.state + ", runtimeId=" + this.runtimeId + ", originalBlock=" + this.originalBlock + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Registration)) {
                return false;
            }
            Registration other = (Registration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BlockState this$state = this.state;
            BlockState other$state = other.state;
            if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
                return false;
            }
            if (this.runtimeId != other.runtimeId) {
                return false;
            }
            CompoundTag this$originalBlock = this.originalBlock;
            CompoundTag other$originalBlock = other.originalBlock;
            return !(this$originalBlock == null ? other$originalBlock != null : !((Object)this$originalBlock).equals(other$originalBlock));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Registration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BlockState $state = this.state;
            result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
            result = result * 59 + this.runtimeId;
            CompoundTag $originalBlock = this.originalBlock;
            result = result * 59 + ($originalBlock == null ? 43 : ((Object)$originalBlock).hashCode());
            return result;
        }
    }
}

