/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command.defaults;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.data.CommandParamType;
import cn.nukkit.command.data.CommandParameter;
import cn.nukkit.command.defaults.VanillaCommand;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.level.Level;
import cn.nukkit.utils.TextFormat;
import java.util.StringJoiner;

public class KillCommand
extends VanillaCommand {
    public KillCommand(String name) {
        super(name, "%nukkit.command.kill.description", "%nukkit.command.kill.usage", new String[]{"suicide"});
        this.setPermission("nukkit.command.kill.self;nukkit.command.kill.other");
        this.commandParameters.clear();
        this.commandParameters.put("default", new CommandParameter[]{CommandParameter.newType("player", true, CommandParamType.TARGET)});
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        EntityDamageEvent ev;
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length >= 2) {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return false;
        }
        if (args.length == 1) {
            if (!sender.hasPermission("nukkit.command.kill.other")) {
                sender.sendMessage(new TranslationContainer((Object)((Object)TextFormat.RED) + "%commands.generic.permission"));
                return true;
            }
            Player player = sender.getServer().getPlayer(args[0]);
            if (player != null) {
                EntityDamageEvent ev2 = new EntityDamageEvent((Entity)player, EntityDamageEvent.DamageCause.SUICIDE, 1000.0f);
                sender.getServer().getPluginManager().callEvent(ev2);
                if (ev2.isCancelled()) {
                    return true;
                }
                player.setLastDamageCause(ev2);
                player.setHealth(0.0f);
                Command.broadcastCommandMessage(sender, new TranslationContainer("commands.kill.successful", player.getName()));
            } else if (args[0].equals("@e")) {
                StringJoiner joiner = new StringJoiner(", ");
                for (Level level : Server.getInstance().getLevels().values()) {
                    for (Entity entity : level.getEntities()) {
                        if (entity instanceof Player) continue;
                        joiner.add(entity.getVisibleName());
                        entity.close();
                    }
                }
                String entities = joiner.toString();
                sender.sendMessage(new TranslationContainer("commands.kill.successful", entities.isEmpty() ? "0" : entities));
            } else if (args[0].equals("@s")) {
                if (!sender.hasPermission("nukkit.command.kill.self")) {
                    sender.sendMessage(new TranslationContainer((Object)((Object)TextFormat.RED) + "%commands.generic.permission"));
                    return true;
                }
                EntityDamageEvent ev3 = new EntityDamageEvent((Entity)((Player)sender), EntityDamageEvent.DamageCause.SUICIDE, 1000.0f);
                sender.getServer().getPluginManager().callEvent(ev3);
                if (ev3.isCancelled()) {
                    return true;
                }
                ((Player)sender).setLastDamageCause(ev3);
                ((Player)sender).setHealth(0.0f);
                sender.sendMessage(new TranslationContainer("commands.kill.successful", sender.getName()));
            } else if (args[0].equals("@a")) {
                if (!sender.hasPermission("nukkit.command.kill.other")) {
                    sender.sendMessage(new TranslationContainer((Object)((Object)TextFormat.RED) + "%commands.generic.permission"));
                    return true;
                }
                for (Level level : Server.getInstance().getLevels().values()) {
                    for (Entity entity : level.getEntities()) {
                        if (!(entity instanceof Player)) continue;
                        entity.setHealth(0.0f);
                    }
                }
                sender.sendMessage(new TranslationContainer((Object)((Object)TextFormat.GOLD) + "%commands.kill.all.successful"));
            } else {
                sender.sendMessage(new TranslationContainer((Object)((Object)TextFormat.RED) + "%commands.generic.player.notFound"));
            }
            return true;
        }
        if (sender instanceof Player) {
            if (!sender.hasPermission("nukkit.command.kill.self")) {
                sender.sendMessage(new TranslationContainer((Object)((Object)TextFormat.RED) + "%commands.generic.permission"));
                return true;
            }
            ev = new EntityDamageEvent((Entity)((Player)sender), EntityDamageEvent.DamageCause.SUICIDE, 1000.0f);
            sender.getServer().getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return true;
            }
        } else {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return false;
        }
        ((Player)sender).setLastDamageCause(ev);
        ((Player)sender).setHealth(0.0f);
        sender.sendMessage(new TranslationContainer("commands.kill.successful", sender.getName()));
        return true;
    }
}

