/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command.defaults;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockID;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.data.CommandParamType;
import cn.nukkit.command.data.CommandParameter;
import cn.nukkit.command.defaults.VanillaCommand;
import cn.nukkit.item.Item;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.level.Level;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockFace;
import java.util.Arrays;

@PowerNukkitOnly
public class SetBlockCommand
extends VanillaCommand {
    @PowerNukkitOnly
    public SetBlockCommand(String name) {
        super(name, "%nukkit.command.setblock.description", "%nukkit.command.setblock.usage");
        this.setPermission("nukkit.command.setblock");
        this.commandParameters.clear();
        this.commandParameters.put("default", new CommandParameter[]{new CommandParameter("position", CommandParamType.POSITION, false), new CommandParameter("tileName", false, (String[])Arrays.stream(BlockID.class.getDeclaredFields()).map(f -> f.getName().toLowerCase()).toArray(String[]::new)), new CommandParameter("tileData", CommandParamType.INT, true), new CommandParameter("oldBlockHandling", true, new String[]{"destroy", "keep", "replace"})});
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        Position position;
        Block block;
        double z;
        double y;
        double x;
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length < 4) {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(new TranslationContainer("commands.setblock.outOfWorld"));
            return true;
        }
        Player player = (Player)sender;
        int data = 0;
        try {
            x = this.parseTilde(args[0], player.x);
            y = this.parseTilde(args[1], player.y);
            z = this.parseTilde(args[2], player.z);
            if (args.length > 4) {
                data = Integer.parseInt(args[4]);
            }
        }
        catch (IndexOutOfBoundsException | NumberFormatException ignored) {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return true;
        }
        String oldBlockHandling = "replace";
        if (args.length > 5) {
            switch (oldBlockHandling = args[5].toLowerCase()) {
                case "destroy": 
                case "keep": 
                case "replace": {
                    break;
                }
                default: {
                    sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
                    return true;
                }
            }
        }
        try {
            int blockId = Integer.parseInt(args[3]);
            block = Block.get(blockId, data);
        }
        catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException ignored) {
            try {
                int blockId = BlockID.class.getField(args[3].toUpperCase()).getInt(null);
                block = Block.get(blockId, data);
            }
            catch (IndexOutOfBoundsException | NullPointerException | ReflectiveOperationException ignored2) {
                sender.sendMessage(new TranslationContainer("commands.setblock.notFound", args[3]));
                return true;
            }
        }
        if (y < 0.0 || y > 255.0) {
            sender.sendMessage(new TranslationContainer("commands.setblock.outOfWorld"));
            return true;
        }
        Level level = player.getLevel();
        Block current = level.getBlock(position = new Position(x, y, z, player.getLevel()));
        if (current.getId() != 0) {
            switch (oldBlockHandling) {
                case "destroy": {
                    level.useBreakOn(position, null, Item.get(0), player, true, true);
                    current = level.getBlock(position);
                    break;
                }
                case "keep": {
                    sender.sendMessage(new TranslationContainer("commands.setblock.noChange"));
                    return true;
                }
            }
        }
        if (current.getId() == block.getId() && current.getDamage() == block.getDamage()) {
            sender.sendMessage(new TranslationContainer("commands.setblock.noChange"));
            return true;
        }
        Item item = block.toItem();
        block.position(position);
        if (block.place(item, block, block.down(), BlockFace.UP, 0.5, 0.5, 0.5, player)) {
            if (args.length > 4) {
                level.setBlockDataAt((int)x, (int)y, (int)z, data);
            }
            sender.sendMessage(new TranslationContainer("commands.setblock.success"));
        } else {
            sender.sendMessage(new TranslationContainer("commands.setblock.failed"));
        }
        return true;
    }
}

